#
# spec file for package gmime (Version 2.2.10)
#
# Copyright (c) 2007 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild
# usedforbuild    Mesa aaa_base acl atk attr audit-libs autoconf automake bash binutils bzip2 cairo coreutils cpio cpp cpp42 cracklib cups-libs cvs diffutils docbook-dsssl-stylesheets docbook-xsl-stylesheets docbook_3 docbook_4 file filesystem fillup findutils fontconfig freetype2 gawk gcc gcc42 gdbm gettext gettext-devel glib-sharp2 glib2 glib2-devel glibc glibc-devel glibc-locale glitz grep groff gtk-doc gtk-sharp2 gtk-sharp2-gapi gtk2 gzip hicolor-icon-theme info insserv iso_ent less libacl libattr libbz2-1 libbz2-devel libdb-4_5 libdrm libexpat1 libgcc42 libgcrypt libgomp42 libgpg-error libjpeg libltdl-3 libmudflap42 libopenssl0_9_8 libpng libreadline5 libstdc++42 libtiff3 libtool libuuid1 libvolume_id libxcrypt libxml2 libxslt libzio linux-kernel-headers m4 make man mktemp mono-core mono-data mono-devel mono-web mono-winforms ncurses net-tools netcfg openjade opensp openssl-certs pam pam-modules pango patch perl perl-XML-LibXML perl-XML-LibXML-Common perl-XML-NamespaceSupport perl-XML-SAX perl-base permissions pkg-config popt rpm sed sgml-skel sysvinit tar texinfo timezone util-linux xorg-x11-libICE xorg-x11-libSM xorg-x11-libX11 xorg-x11-libXau xorg-x11-libXdmcp xorg-x11-libXext xorg-x11-libXfixes xorg-x11-libXmu xorg-x11-libXp xorg-x11-libXpm xorg-x11-libXprintUtil xorg-x11-libXrender xorg-x11-libXt xorg-x11-libXv xorg-x11-libfontenc xorg-x11-libs xorg-x11-libxcb xorg-x11-libxkbfile zlib zlib-devel

Name:           gmime
BuildRequires:  glib-sharp2 glib2-devel gtk-doc gtk-sharp2 gtk-sharp2-gapi mono-devel zlib-devel
Version:        2.2.10
Release:        36
Url:            http://spruce.sourceforge.net/gmime/
Group:          Productivity/Networking/Email/Utilities
License:        GPL v2 or later, LGPL v2 or later
Summary:        MIME Library Utilities
Source:         %{name}-%{version}.tar.bz2
Patch1:         gmime-mono-largefile-support.patch
Patch2:         gnome-bugzilla-id-485005.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Requires:       libgmime-2_0-2 = %{version}

%description
GMime is a set of utilities for parsing and creating messages using the
Multipurpose Internet Mail Extension (MIME).



Authors:
--------
    Jeffrey Stedfast <fejj@gnome.org>

%debug_package
%package -n libgmime-2_0-2
Group:          Development/Libraries/C and C++
Summary:        MIME Library
Requires:       %{name} >= %{version}

%description -n libgmime-2_0-2
GMime is a set of utilities for parsing and creating messages using the
Multipurpose Internet Mail Extension (MIME).



Authors:
--------
    Jeffrey Stedfast <fejj@gnome.org>

%package sharp
Group:          Development/Libraries/Other
Summary:        MIME Library Mono Bindings
Requires:       libgmime-2_0-2 = %{version} gtk-sharp2 glib-sharp2

%description sharp
GMime is a set of utilities for parsing and creating messages using the
Multipurpose Internet Mail Extension (MIME).



Authors:
--------
    Jeffrey Stedfast <fejj@gnome.org>

%package devel
Group:          Development/Libraries/C and C++
Summary:        MIME Library
Requires:       libgmime-2_0-2 = %{version} glib2-devel zlib-devel glibc-devel

%description devel
GMime is a set of utilities for parsing and creating messages using the
Multi-purpose Internet Mail Extension (MIME).



Authors:
--------
    Jeffrey Stedfast <fejj@ximian.com>

%package doc
Group:          Development/Libraries/C and C++
Summary:        MIME Library documentation

%description doc
GMime is a set of utilities for parsing and creating messages using the
Multipurpose Internet Mail Extension (MIME).

This package contains additional documentation for the main package.



Authors:
--------
    Jeffrey Stedfast <fejj@ximian.com>

%prep
%setup -q
%patch1 -p0
%patch2 -p0

%build
cp /usr/share/gettext/config.rpath .
autoreconf -f -i
%configure\
	--disable-static\
	--enable-rfc2047-workarounds\
	--enable-largefile
make %{?jobs:-j%jobs}

%install
%makeinstall
# rename to prevent conflict with uu* utils from sharutils
mv $RPM_BUILD_ROOT%{_bindir}/uuencode $RPM_BUILD_ROOT%{_bindir}/gmime-uuencode
mv $RPM_BUILD_ROOT%{_bindir}/uudecode $RPM_BUILD_ROOT%{_bindir}/gmime-uudecode
for FILE in COPYING ; do
    MD5SUM=$(md5sum $FILE | sed 's/ .*//')
    if test -f /usr/share/doc/licenses/md5/$MD5SUM ; then
        ln -sf /usr/share/doc/licenses/md5/$MD5SUM $FILE
    fi
done
# Obsolete GNOME1 gnome-config style:
rm $RPM_BUILD_ROOT%{_libdir}/*Conf.sh

%clean
rm -rf $RPM_BUILD_ROOT

%post -n libgmime-2_0-2 -p /sbin/ldconfig

%postun -n libgmime-2_0-2 -p /sbin/ldconfig

%files
%defattr (-, root, root)
# NEWS is empty
%doc AUTHORS COPYING ChangeLog PORTING README TODO
%{_bindir}/*

%files -n libgmime-2_0-2
%defattr (-, root, root)
%{_libdir}/*.so.*

%files sharp
%defattr (-, root, root)
%dir %{_prefix}/lib/mono/gmime-sharp
%dir %{_prefix}/lib/mono/gac/gmime-sharp
%dir %{_prefix}/lib/mono/gac/gmime-sharp/2.2.0.0__677013d4cb5910f0
%{_prefix}/lib/mono/gmime-sharp/gmime-sharp.dll
%{_prefix}/lib/mono/gac/gmime-sharp/2.2.0.0__677013d4cb5910f0/gmime-sharp.dll
%{_prefix}/lib/mono/gac/gmime-sharp/2.2.0.0__677013d4cb5910f0/gmime-sharp.dll.config
# devel files:
%{_datadir}/gapi-2.0/gmime-api.xml
%{_libdir}/pkgconfig/gmime-sharp.pc

%files devel
%defattr (-, root, root)
%{_includedir}/gmime-2.0
%{_libdir}/*.*a
%{_libdir}/*.so
%{_libdir}/pkgconfig/gmime-2.0.pc

%files doc
%defattr (-, root, root)
%{_datadir}/gtk-doc/html/*
%changelog
* Wed Nov 07 2007 - nice@titanic.nyme.hu
- Add a patch by Jeffrey Stedfast <fejj@gnome.org> to fix the
  problem described at http://bugzilla.gnome.org/show_bug.cgi?id=485005
* Tue Sep 25 2007 - joeshaw@suse.de
- Add a patch to fix the Mono bindings when GMime is built with
  large file support.  (bnc #327589)
* Wed Aug 08 2007 - sbrabec@suse.cz
- Fixed dependencies to allow to install more instances of library.
* Wed Aug 08 2007 - ro@suse.de
- remove devel dependencies from library package
* Mon Aug 06 2007 - sbrabec@suse.cz
- Updated to version 2.2.10:
  * Implemented a conditional workaround for broken rfc2047
  encodings.
- Enabled large file support and broken rfc2047 workaround.
- Split package according to shared library policy.
- Package gmime-sharp separately.
* Mon Jul 16 2007 - sbrabec@suse.cz
- Fixed licenses linking.
* Sun Jul 15 2007 - aj@suse.de
- Build sharp files again.
* Fri Jul 13 2007 - sbrabec@suse.cz
- Updated to version 2.2.9:
  * New functions.
  * Bug fixes.
  * Memory leak fixes.
* Fri Mar 30 2007 - rguenther@suse.de
- Add zlib-devel BuildRequires
* Fri Feb 16 2007 - mvaner@suse.cz
- Compare strings properly, not as pointers, bug #225721
  - stdin-cmp.patch
* Tue Feb 13 2007 - sbrabec@suse.cz
- Do not build unusable static libraries (#238552#c17).
* Tue Feb 06 2007 - sbrabec@suse.cz
- Reduced BuildRequires.
* Wed Jan 10 2007 - sbrabec@suse.cz
- Spec file cleanup.
* Tue Jan 09 2007 - joeshaw@suse.de
- Clean up BuildRequires
* Mon Jan 08 2007 - ro@suse.de
- GNOME moved to /usr
* Fri Oct 20 2006 - sbrabec@suse.cz
- Update to version 2.2.3:
  * Decode the values for Subject, From, Reply-To.
  * Code imporvements.
  * Bug fixes.
* Mon Oct 16 2006 - schwab@suse.de
- Make sure config.rpath is present.
* Fri Mar 17 2006 - joeshaw@suse.de
- Update to version 2.2.1.  This contains a fix for reading mbox
  files in the middle of the last message, which would cause a
  tight CPU loop.  Fixes bnc #156916 and probably also #156927.
* Thu Feb 16 2006 - joeshaw@suse.de
- Update the official tarball from 2.1.18 to 2.1.19.  There are
  actually no changes to the code at all, since the (now removed)
  backported patch contained all the differences between 2.1.18
  and 2.1.19.  This just makes already fixed bugs like bnc 147515
  a lot easier to spot.
* Wed Jan 25 2006 - mls@suse.de
- converted neededforbuild to BuildRequires
* Sat Jan 21 2006 - joeshaw@suse.de
- Added a patch which backports an important fix from 2.1.19 to
  2.1.18.
* Fri Jan 13 2006 - gekker@suse.de
- Fixup nfb and requires for new gtk-sharp2-packaging
- Fixup filelist
* Fri Jan 13 2006 - joeshaw@suse.de
- Updated to version 2.1.18
* Tue Jan 10 2006 - sbrabec@suse.cz
- Updated to version 2.1.17.
* Sun Sep 04 2005 - aj@suse.de
- build as non-root.
- Add check-build.sh.
* Fri Aug 19 2005 - gekker@suse.de
- Updated to version 2.1.16
- Require gtk-sharp2
* Tue Jul 12 2005 - sbrabec@suse.cz
- Updated to version 2.1.15.
* Mon Mar 14 2005 - gekker@suse.de
- Add gmime-mono-leak.patch to fix memory leaks.
* Tue Mar 08 2005 - gekker@suse.de
- Update to version 2.1.13
* Tue Feb 08 2005 - ro@suse.de
- rename uu{en,de}code to avoid conflict with sharutils
  (taken from source-provided specfile)
* Mon Feb 07 2005 - ro@suse.de
- gtk-doc docu back to /opt/gnome
* Fri Feb 04 2005 - gekker@suse.de
- Update to version 2.1.11.
- Enable C# bindings, add deps to neededforbuild
- Change prefix to /usr, for mono to work
* Thu Jan 06 2005 - sbrabec@suse.cz
- Updated to version 2.1.9.
* Fri Aug 20 2004 - sbrabec@suse.cz
- Updated to unstable version 2.1.7, needed by balsa.
* Fri Aug 20 2004 - ke@suse.de
- gmime-doc.patch: Switch to DocBook DTD 4.1; version 3.0 does not
  support QANDASET, etc; reported by Stanislav Brabec.
* Thu Aug 19 2004 - sbrabec@suse.cz
- New SuSE package, version 2.0.14.
