using System;

using FSpot;
using FSpot.Extensions;
using System.Runtime.InteropServices;

namespace FSpot.Extensions {

	public class DVD_SlideShowExtension: FSpot.Extensions.ExportExtension
	{
		protected override string ConfigurationName { get { return "DVD_SlideShowExtension"; } }
		public override string DisplayName { get { return "DVD Slideshow Extension"; } }
		public override string Description { get { return "This extension will create a DVD slideshow of selected photos"; } }
		public override string MenuEntryName { get { return "DVD Slideshow"; } }
		public override ExtensionRevision Revision { get { return new ExtensionRevision(0, 0, 1); } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Bengt Thuree <bengt@thuree.com>"
				};
			} 
		}

		public DVD_SlideShowExtension () : base()
		{
			Console.WriteLine("new DVD-SlideShowExtension instanciated !");	
		}

/*
We will create the following import file.
title:5:This is my title
fadein:2
picture 1.jpg:4
fadein:2
pano.jpg:4
fadein:2
picture2.jpg:3
fadeout:2

We aim for the below pseudocode
Loop
	Create control file
	dvd-slideshow -n 'test complete' -f Complete_example.txt -a 'strojovna_07-TEXEMPO-30s.ogg'
	store photos internally
	
dvd-menu -t 'My example' -t 'Slideshow 2' -f test_complete.xml -f test_complete.xml -n 'Complete Example DVD'

cp -a <stored photos> dvd_fs
mkisofs -dvd-video -udf -o dvd.iso dvd_fs

Gui
	Create another slideshow on same dvd
	Finished, create slideshow now
	Quit

If BASH3 && dvd-slideshow <= 0.7.2 ---> Warning!

*/
		System.IO.StreamWriter stream;
		
		private string CreateWorkDirectory()
		{
			// Create a tmp directory.
			string tmp_dir = System.IO.Path.GetTempFileName ();	// Create a tmp file	
			System.IO.File.Delete (tmp_dir);			// Delete above tmp file
			System.IO.Directory.CreateDirectory (tmp_dir);		// Create a directory with above tmp name
			return tmp_dir;
		}

		string work_directory;
		private string WorkDirectory
		{
			get { if (work_directory == null)
				work_directory = CreateWorkDirectory();
				return work_directory;
			}
			set { work_directory = value; 
			}
		}

		
		private string ControlFile {
			get { return "f-spot_slideshow.txt"; }
		}
		
		private System.IO.StreamWriter CreateMasterFile()
		{
			string master_file = GetMasterFile(); 
			return new System.IO.StreamWriter (master_file);
		}

		private string GetMasterFile()
		{
			string master_file = String.Format ("{0}{1}{2}.txt",
							       WorkDirectory,
							       System.IO.Path.DirectorySeparatorChar,
							       ControlFile);
			return master_file;
		}

		private string GetDVDMasterFile()
		{
			string str = GetMasterFile();
			str.Replace (".txt", ".xml");
			return str;
		}
		
		private void AddTitle ()
		{
			stream.WriteLine ("title:5:F-Spot created slideshow");
		}
		
		private void SetFading()
		{
			stream.WriteLine ("fadein:2");
		}
		
		private void AddPhoto (string photo_path)
		{
			SetFading();
			stream.WriteLine ("{0}:5", photo_path);
		}

		private void CreateControlFile()
		{
			stream = CreateMasterFile();
			AddTitle ();
			foreach (Photo p in photos.Items) 
				AddPhoto (p.DefaultVersionUri.LocalPath);
			AddEnding ();
			stream.Close();
			
			Console.WriteLine ("Created a DVD slideshow master file for {0} pictures", photos.Count);	
		}
		
		private void AddEnding ()
		{
			stream.WriteLine ("fadeout:2");
		}

		[DllImport ("libc")] 
		extern static int system (string program);
		
		private void RunDvdSlideShow()
		{
			// dvd-slideshow -n 'test complete' -f Complete_example.txt -a 'strojovna_07-TEXEMPO-30s.ogg'
			string cmd = String.Format ("dvd-slideshow -n '{0}' -f {1} -o {2}",
				"F-Spot test complete", GetMasterFile(), WorkDirectory);
			system (cmd); 
		}
		
		private void RunDvdMenu()
		{
			// dvd-menu -t 'My example' -t 'Slideshow 2' -f test_complete.xml -f test_complete.xml -n 'Complete Example DVD'
			string cmd = String.Format ("dvd-menu -t '{0}' -t '{1}' -f {2} -f {3} -n '{4}",
				"F-Spot slideshow 1",
				"F-Spot slideshow 2",
				GetDVDMasterFile(),
				GetDVDMasterFile(),
				"Finished");
			system (cmd);
		}
		
		private void StorePhotos()
		{
//			foreach (Photo p in photos.Items) 
//				System.IO.File.Copy (p.DefaultVersionUri.LocalPath, "dvd_fs/orig_photos/");
		}
		
		private void MkDvdIso()
		{
		}
		
		private void LaunchIsoBurner()
		{
		}
		
		protected override void Run()
		{
			CreateControlFile();
			RunDvdSlideShow();
			RunDvdMenu();
			StorePhotos();
			MkDvdIso();
			LaunchIsoBurner();
		}

		protected override void ExtensionInitialize()
		{
			Console.WriteLine("Initializing DVD-SlideShowExtension");	
		}

		protected override void ExtensionDispose()
		{
			Console.WriteLine("Disposing DVD-SlideShowExtension");
		}
	}
}
