/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * SISSI diagram -  adapted by Luc Cessieux
 * This class could draw the system security
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <string.h>
#include <glib.h>
#include "menace.h"

SISSI_Property_Menace *copy_menace(gchar *label_menace,gchar *comments_menace,float action,float detection,float vulnerability)
{
  SISSI_Property_Menace *property;
  property = g_new0(SISSI_Property_Menace, 1);

/********** gestion of label ************/
  if (property->label != NULL)
    g_free(property->label);
  if (label_menace && label_menace[0])
    property->label = g_strdup (label_menace);
  else
    property->label = NULL;

/********** gestion of comments ************/
  if (property->comments != NULL)
    g_free(property->comments);
  if (comments_menace && comments_menace[0])
    property->comments = g_strdup (comments_menace);
  else
    property->comments = NULL;

  property->action=action;
  property->detection=detection;
  property->vulnerability=vulnerability;
  
  return property;

}

void clear_new_properties_menace(gchar *label_menace, SISSI_Property_Menace *property)
{
/*********** label **********/  
  if (property->label != NULL)
    g_free(property->label);
  
  if (label_menace && label_menace[0])
    property->label = g_strdup (label_menace);
  else
    property->label = NULL;
    
/*********** comments **********/
  if (property->comments != NULL)
    g_free(property->comments);
  property->comments = g_strdup ("");

 property->action=property->detection=property->vulnerability=0.0f;
}

GList *create_list_properties_menace(GList *list_property_menace, gchar *entity_type)
{

SISSI_Property_Menace *property1,*property2,*property3,*property4,*property5,*property6,*property7,*property8,*property9,*property10;
SISSI_Property_Menace *property11,*property12,*property13,*property14,*property15,*property16,*property17,*property18,*property19,*property20;
SISSI_Property_Menace *property21,*property22,*property23,*property24,*property25,*property26,*property27,*property28,*property29,*property30;
SISSI_Property_Menace *property31,*property32,*property33,*property34,*property35,*property36,*property37,*property38,*property39,*property40;
SISSI_Property_Menace *property41,*property42;

/* fprintf(stderr,"espion create_list_properties_menace, %s \n",entity_type);*/

if(strcmp(entity_type,"PHYSIC")==0 || strcmp(entity_type,"PHY_DETECTION_FIRE")==0|| strcmp(entity_type,"PHY_ACTION_FIRE")==0)
{
 property1 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Fire", property1);
 list_property_menace = g_list_prepend(list_property_menace, property1);
} 
if(strcmp(entity_type,"PHYSIC")==0|| strcmp(entity_type,"PHY_DETECTION_WATER")==0|| strcmp(entity_type,"PHY_ACTION_WATER")==0)
{
 property2 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Water damage",property2);
 list_property_menace = g_list_append(list_property_menace, property2);
}
if(strcmp(entity_type,"PHYSIC")==0|| strcmp(entity_type,"PHY_DETECTION_AIR")==0|| strcmp(entity_type,"PHY_ACTION_AIR")==0|| strcmp(entity_type,"PHY_DETECTION_WATER")==0|| strcmp(entity_type,"PHY_ACTION_WATER")==0)
{
 property3 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Pollution",property3);
 list_property_menace = g_list_append(list_property_menace, property3);
}
if(strncmp(entity_type,"PHY",3)==0)
{
 property4 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Major accidents",property4);
 list_property_menace = g_list_append(list_property_menace, property4);
}
if(strncmp(entity_type,"PHY",3)==0 || strcmp(entity_type,"NETWORK")==0 || strcmp(entity_type,"SYSTEM")==0 || strcmp(entity_type,"MATERIAL")==0)
{
 property5 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Materials or supports destroy",property5);
 list_property_menace = g_list_append(list_property_menace, property5);
}
if(strncmp(entity_type,"PHY",3)==0)
{
 property6 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Climatic phenomenon",property6);
 list_property_menace = g_list_append(list_property_menace, property6);
}
if(strcmp(entity_type,"PHYSIC")==0)
{
 property7 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Seismic phenomen",property7);
 list_property_menace = g_list_append(list_property_menace, property7);
}
if(strcmp(entity_type,"PHYSIC")==0)
{
 property8 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Volcanic phenomen",property8);
 list_property_menace = g_list_append(list_property_menace, property8);
}
if(strncmp(entity_type,"PHY",3)==0)
{
 property9 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Meteorological phenomen",property9);
 list_property_menace = g_list_append(list_property_menace, property9);
}
if(strcmp(entity_type,"PHYSIC")==0 ||strcmp(entity_type,"PHY_DETECTION_WATER")==0 ||strcmp(entity_type,"PHY_ACTION_WATER")==0)
{
 property10 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Flood",property10);
 list_property_menace = g_list_append(list_property_menace, property10);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"PHY_DETECTION_AIR")==0||strcmp(entity_type,"PHY_ACTION_AIR")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"PHYSIC")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property11 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Failure of air-conditioning",property11);
 list_property_menace = g_list_append(list_property_menace, property11);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property12 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Loss of power supply",property12);
 list_property_menace = g_list_append(list_property_menace, property12);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property13 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Failure of telecommunication equipment",property13);
 list_property_menace = g_list_append(list_property_menace, property13);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property14 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Electromagnetic radiation",property14);
 list_property_menace = g_list_append(list_property_menace, property14);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property15 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Thermal radiations",property15);
 list_property_menace = g_list_append(list_property_menace, property15);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property16 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Electromagnetic pulse (emp)",property16);
 list_property_menace = g_list_append(list_property_menace, property16);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property17 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Interception of compromising interference signals",property17);
 list_property_menace = g_list_append(list_property_menace, property17);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"PHYSIC")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property18 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Remote spying",property18);
 list_property_menace = g_list_append(list_property_menace, property18);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"PHYSIC")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property19 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Eavesdropping",property19);
 list_property_menace = g_list_append(list_property_menace, property19);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property20 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Theft of media or documents",property20);
 list_property_menace = g_list_append(list_property_menace, property20);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property21 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Theft of equipment",property21);
 list_property_menace = g_list_append(list_property_menace, property21);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strcmp(entity_type,"PHYSIC")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property22 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Retrieval of recycled or discarded media",property22);
 list_property_menace = g_list_append(list_property_menace, property22);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"PERSON")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property23 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Disclosure",property23);
 list_property_menace = g_list_append(list_property_menace, property23);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property24 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Data from untrustworthy sources",property24);
 list_property_menace = g_list_append(list_property_menace, property24);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"PERSON")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property25 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Tampering with hardware",property25);
 list_property_menace = g_list_append(list_property_menace, property25);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"PERSON")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strncmp(entity_type,"PHY_ACTION",10)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property26 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Tampering with software",property26);
 list_property_menace = g_list_append(list_property_menace, property26);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"PERSON")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property27 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Position detection",property27);
 list_property_menace = g_list_append(list_property_menace, property27);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0){
 property28 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Equipment failure",property28);
 list_property_menace = g_list_append(list_property_menace, property28);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property29 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Equipment malfunction",property29);
 list_property_menace = g_list_append(list_property_menace, property29);
}
if(strcmp(entity_type,"SYSTEM")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strncmp(entity_type,"PHY_ACTION",10)==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property30 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Saturation of the information system",property30);
 list_property_menace = g_list_append(list_property_menace, property30);
}
if(strcmp(entity_type,"SYSTEM")==0||strncmp(entity_type,"PHY_DETECTION",13)==0||strncmp(entity_type,"PHY_ACTION",10)==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0)
{
 property31 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Software malfunction",property31);
 list_property_menace = g_list_append(list_property_menace, property31);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property32 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Breach of information system maintainability",property32);
 list_property_menace = g_list_append(list_property_menace, property32);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property33 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Unauthorised use of equipment",property33);
 list_property_menace = g_list_append(list_property_menace, property33);
}
if(strcmp(entity_type,"SOFTWARE")==0)
{
 property34 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Fraudulent copying of software",property34);
 list_property_menace = g_list_append(list_property_menace, property34);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0)
{
 property35 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Use of counterfeit or copied software",property35);
 list_property_menace = g_list_append(list_property_menace, property35);
}
if(strncmp(entity_type,"PHY",3)==0)if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property36 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Corruption of data",property36);
 list_property_menace = g_list_append(list_property_menace, property36);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"PERSON")==0||strncmp(entity_type,"PHY_",4)==0||strcmp(entity_type,"MATERIAL")==0)
{
 property37 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Illegal processing of data",property37);
 list_property_menace = g_list_append(list_property_menace, property37);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"MATERIAL")==0||strncmp(entity_type,"PHY_",4)==0)
{
 property38 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Error in use",property38);
 list_property_menace = g_list_append(list_property_menace, property38);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property39 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Abuse of rights",property39);
 list_property_menace = g_list_append(list_property_menace, property39);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property40 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Forging of rights",property40);
 list_property_menace = g_list_append(list_property_menace, property40);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strcmp(entity_type,"MATERIAL")==0||strncmp(entity_type,"PHY_",4)==0)
{
 property41 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Denial of actions",property41);
 list_property_menace = g_list_append(list_property_menace, property41);
}
if(strcmp(entity_type,"SYSTEM")==0||strcmp(entity_type,"NETWORK")==0||strcmp(entity_type,"SOFTWARE")==0||strncmp(entity_type,"PHY",3)==0||strcmp(entity_type,"ORGANIZATION")==0||strcmp(entity_type,"PERSON")==0||strcmp(entity_type,"MATERIAL")==0)
{
 property42 = g_malloc0(sizeof(SISSI_Property_Menace));
 create_new_properties_menace("Breach of personnel availability",property42);
 list_property_menace = g_list_append(list_property_menace, property42);
}
  return list_property_menace;
}

GList *clear_list_property_menace (GList *list)
{  
  while (list != NULL) {
    SISSI_Property_Menace *property_menace = (SISSI_Property_Menace *) list->data;
    g_free(property_menace->label);
    g_free(property_menace->comments);/*
//     g_free(property_menace->action);
//     g_free(property_menace->detection);
//     g_free(property_menace->vulnerability);
*/
    g_free(property_menace);
    list = g_list_next(list);
  }
  g_list_free(list);
  return list;
}

GList *clear_list_property_menace_widget (GList *list)
{  
  while (list != NULL) {
    SISSI_Property_Menace_Widget *property_menace = (SISSI_Property_Menace_Widget *) list->data;
    gtk_widget_destroy(property_menace->label);
    gtk_widget_destroy(property_menace->comments);
    gtk_widget_destroy(property_menace->action);
    gtk_widget_destroy(property_menace->detection);
    gtk_widget_destroy(property_menace->vulnerability);
    g_free(property_menace);
    list = g_list_next(list);
  }
  g_list_free(list);
  return list;
}
