
typedef struct _WebxPalette
{
  gint        num_colors;
} WebxPalette;

typedef struct _WebxSource
{
  /* image dimensions, as they come from original image */
  gint        original_width;
  gint        original_height;
  /* after resizing stage */
  gint        resize_width;
  gint        resize_height;
  /* after crop stage */
  gint        crop_width;
  gint        crop_height;
  gint        crop_offsx;
  gint        crop_offsy;
  /* image from user */
  gint32      user_image;
  gint32      user_drawable;
  /* rgb image after transformations */
  gint32      rgb_image;
  gint32      rgb_layer;
  /* paletted image after transformations */
  gint32      indexed_image;
  gint32      indexed_layer;
  /* pixbufs */
  GdkPixbuf   *background_pixbuf;

  gdouble      crop_scale_x;
  gdouble      crop_scale_y;
} WebxSource;

void         webx_source_init (gint32 image_ID,
                               gint32 drawable_ID);
void         webx_source_cleanup (void);

/* Original with transformations */
void         webx_source_get_rect   (GdkRectangle *rect);

/* Background (for cropped out areas) */
GdkPixbuf   *webx_background_get_pixbuf (void);
gint         webx_background_get_width  (void);
gint         webx_background_get_height (void);

gboolean     webx_source_resize (gint     newheight,
                                 gint     newwidth);
gboolean     webx_source_crop (gint     width,
                               gint     height,
                               gint     offsx,
                               gint     offsy,
                               gboolean clip_offsets);

gint32       webx_source_get_rgb (gint32    *layer);
gint32       webx_source_get_indexed (gint32    *layer);

void         webx_source_invalidate (gboolean delete_bg);

/*
 * private */
 
gboolean     webx_source_update (void);
