
#include "config.h"

#include <string.h>

#include <glib.h>
#include <glib/gstdio.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "webx_main.h"
#include "webx_source.h"
#include "webx_dialog.h"
#include "webx_indexed.h"
#include "webx_gif.h"
#include "webx_widgets.h"

#include "libgimp/stdplugins-intl.h"

static WebxGIFSettings  webx_gif;
static WebxIndexed      webx_indexed;

void
webx_gif_init ()
{
  webx_gif.interlace  = 0;
  webx_indexed_init (&webx_indexed);
}

void
webx_gif_cleanup ()
{
  webx_indexed_cleanup (&webx_indexed);
}

GtkWidget*
webx_gif_toolbox_new ()
{
  GtkWidget   *box;
  GtkWidget   *check;
  GtkWidget   *indexed;
  GtkWidget   *table;
  gint         row = 0;

  box = gtk_vbox_new (FALSE, 0);

  indexed = webx_indexed_create_widgets (&webx_indexed);
  gtk_box_pack_start (GTK_BOX (box), indexed, FALSE, FALSE, 0);
  g_object_set_data (G_OBJECT (box), "indexed", indexed);

  table = gtk_table_new (1, 3, FALSE);
  gtk_box_pack_start (GTK_BOX (box), table, FALSE, FALSE, 0);

  check = gtk_check_button_new_with_label (_("Interlace"));
  gtk_table_attach (GTK_TABLE (table), check,
		    0, 3, row, row+1,
		    GTK_FILL, GTK_FILL, 0, 0);
  g_signal_connect (check, "toggled",
		    G_CALLBACK (webx_widgets_boolean_update),
		    &webx_gif.interlace);
  g_object_set_data (G_OBJECT (box), "interlace", check);

  return box;
}

void
webx_gif_toolbox_update (GtkWidget *toolbox)
{
  GtkWidget   *adj;
  GtkWidget   *w;

  w = g_object_get_data (G_OBJECT (toolbox), "indexed");
  webx_indexed_update_widgets (w, &webx_indexed);

  adj = g_object_get_data (G_OBJECT (toolbox), "interlace");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (adj),
				(gboolean) webx_gif.interlace);
}

gboolean
webx_gif_save (const gchar *file_name)
{
  GimpParam    *return_vals;
  gint          n_return_vals;
  gint          image;
  gint          layer;
  gboolean      save_res;

  image = webx_indexed_get_image (&webx_indexed, &layer);
  if (image == -1)
    return FALSE;

  return_vals = gimp_run_procedure ("file-gif-save", &n_return_vals,
				    GIMP_PDB_INT32, GIMP_RUN_NONINTERACTIVE,
				    GIMP_PDB_IMAGE, image,
				    GIMP_PDB_DRAWABLE, layer,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_INT32, webx_gif.interlace,
				    GIMP_PDB_INT32, 0,
				    GIMP_PDB_INT32, 0,
				    GIMP_PDB_INT32, 0,
				    GIMP_PDB_END);
  if (return_vals[0].data.d_int32 == GIMP_PDB_SUCCESS)
    save_res = TRUE;
  else
    save_res = FALSE;
  g_assert (save_res);
  gimp_destroy_params (return_vals, n_return_vals);

  return save_res;
}

static gint32
webx_gif_load (const gchar *file_name)
{
  GimpParam  *return_vals;
  gint        n_return_vals;
  gint32      image;

  return_vals = gimp_run_procedure ("file-gif-load", &n_return_vals,
				    GIMP_PDB_INT32, GIMP_RUN_NONINTERACTIVE,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_STRING, file_name,
				    GIMP_PDB_END);
  image = return_vals[1].data.d_image;
  gimp_destroy_params (return_vals, n_return_vals);

  g_assert (image != -1);
  return image;
}

GdkPixbuf*
webx_gif_generate_preview ()
{
  char        *file_name;
  GdkPixbuf   *pixbuf = NULL;
  gint32       image;

  file_name = gimp_temp_name ("GIF");
  if (webx_gif_save (file_name))
    {
      webx_dialog_update_file_size (file_name);
      image = webx_gif_load (file_name);
      if (image != -1)
        {
	  pixbuf = webx_image_to_pixbuf (image);
	  gimp_image_delete (image);
        }
    }
  g_unlink (file_name);
  g_free (file_name);

  return pixbuf;
}

void
webx_gif_invalidate (void)
{
  webx_indexed_invalidate (NULL, &webx_indexed);
}
