Index: keybindings.py
===================================================================
RCS file: /cvs/gnome/orca/src/orca/keybindings.py,v
retrieving revision 1.11
diff -u -r1.11 keybindings.py
--- keybindings.py	10 Nov 2006 22:45:54 -0000	1.11
+++ keybindings.py	16 Nov 2006 17:19:51 -0000
@@ -39,6 +39,8 @@
 import atspi
 import debug
 
+from orca_i18n import _           # for gettext support
+
 _keycodeCache = {}
 
 def _getKeycode(keysym):
@@ -94,6 +96,31 @@
 
     return _keycodeCache[keysym]
 
+def getModifierNames(mods):
+    """ Gets the modifier names of a numeric modifier mask
+    """
+
+    text = ""
+    if mods & 256:
+        text += _("OrcaMod.") + "+"
+    if mods & 128:
+        text += _("Alt_R") + "+"
+    if mods & 64:
+        text += _("Super") + "+"
+    if mods & 32:
+        text += _("??") + "+"
+    #if mods & 16:
+    #    text += _("Num_Lock") + "+"
+    if mods & 8:
+        text += _("Alt_L") + "+"
+    if mods & 4:
+        text += _("Ctrl") + "+"
+    #if mods & 2:
+    #    text += _("Caps_Lock") + "+"
+    if mods & 1:
+        text += _("Shift") + "+"
+    return text
+
 class KeyBinding:
     """A single key binding, consisting of a keycode, a modifier mask,
     and the InputEventHandler.
@@ -159,6 +186,35 @@
             if keyBinding == self.keyBindings[i]:
                 del self.keyBindings[i]
 
+    def hasKeyBinding (self, newKeyBinding, typeOfSearch="strict"):
+        """Return True if keyBinding is already in self.keyBindings.
+        
+           The typeOfSearch can be:
+              "strict":      matches everything (description, modifiers and key).
+              "description": matches only description.
+              "keys":        matches only modifiers and key.
+        """
+        
+        hasIt = False
+        
+        for keyBinding in self.keyBindings:
+            if typeOfSearch == "strict":
+                if keyBinding.handler._description == newKeyBinding.handler._description and \
+                    keyBinding.keysymstring        == newKeyBinding.keysymstring and \
+                    keyBinding.modifier_mask       == newKeyBinding.modifier_mask and \
+                    keyBinding.modifiers           == newKeyBinding.modifiers:
+                        hasIt = True
+            elif typeOfSearch == "description":
+                if keyBinding.handler._description == newKeyBinding.handler._description:
+                        hasIt = True
+            elif typeOfSearch == "keys":
+                if keyBinding.keysymstring   == newKeyBinding.keysymstring and \
+                    keyBinding.modifier_mask == newKeyBinding.modifier_mask and \
+                    keyBinding.modifiers     == newKeyBinding.modifiers:
+                        hasIt = True
+            
+        return hasIt
+        
     def getInputHandler(self, keyboardEvent):
         """Returns the input handler of the key binding that matches the
         given keycode and modifiers, or None if no match exists.
