using System;
using System.IO;

using Gtk;



using ICSharpCode.SharpZipLib.Checksums;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.GZip;

using FSpot;
using FSpot.Extensions;

namespace FSpot.Extensions {

	public class ExportZip: FSpot.Extensions.ExportExtension
	{
		Crc32 crc;
		ZipOutputStream s;
	    FileSelection fs;


		protected override string ConfigurationName { get { return "ExportZip"; } }
		public override string DisplayName { get { return "ExportZip"; } }
		public override string Description { get { return "This Extension exports to a zip file"; } }
		public override string MenuEntryName { get { return "Save as Zip"; } }
		public override ExtensionRevision Revision { get { return new ExtensionRevision(0,1,1); } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Kevin Sheehan",
					"SecondGuy"
				};
			} 
		}
		


		public ExportZip () : base()
		{
			Console.WriteLine("new ExportZip instanciated !");	
			//This will enable this extension at first load
			//Preferences.Get("Enabled", true);
			
			//This will enable this extension at startup
			//Preferences.Set("Enabled", true);

			
		}
		
		private void WriteZip(string filename)
		{
			crc = new Crc32();
			s = new ZipOutputStream(File.Create(filename));
			
			s.SetLevel(0);
			//for (int i = 0; i < collection.Count; i++){
			foreach (Photo p in photos.Items) {
				//ProcessImage (i);
				//IBrowsableItem photo = collection [image_num];
				string photo_path = p.DefaultVersionUri.LocalPath;
				
				FileStream fs = File.OpenRead(photo_path);
			
				byte[] buffer = new byte[fs.Length];
				fs.Read(buffer, 0, buffer.Length);
				ZipEntry entry = new ZipEntry(Path.GetFileName(photo_path));
			
				entry.DateTime = DateTime.Now;
			
				// set Size and the crc, because the information
				// about the size and crc should be stored in the header
				// if it is not set it is automatically written in the footer.
				// (in this case size == crc == -1 in the header)
				// Some ZIP programs have problems with zip files that don't store
				// the size and crc in the header.
				entry.Size = fs.Length;
				fs.Close();
			
				crc.Reset();
				crc.Update(buffer);
			
				entry.Crc  = crc.Value;
			
				s.PutNextEntry(entry);
			
				s.Write(buffer, 0, buffer.Length);
				
				
			}
			s.Finish();
			s.Close();

		
		}

		protected override void Run()
		{
          fs = new FileSelection ("Choose a file");
          fs.Response += new Gtk.ResponseHandler (OnFileSelectionResponse);
          fs.Run();
          fs.Destroy();
			     
					
					
			//WriteZip("/home/kevin/testexport.zip");
			Console.WriteLine ("Exporting {0} pictures", photos.Count);	
		}

	    void OnFileSelectionResponse (object o, ResponseArgs args)
	     {
	          if (args.ResponseId == ResponseType.Ok)
	          {
	               //lbl.Text = "Selected: " + fs.Filename;
	               WriteZip(fs.Filename);
	               
	          }
	          
	     }


		protected override void ExtensionInitialize()
		{
			Console.WriteLine("Initializing DummyExtension");	
		}

		protected override void ExtensionDispose()
		{
			Console.WriteLine("Disposing DummyExtension");
		}
	}
	
}
