/*
 * DefaultImporterExtension.cs
 *
 * Authors:
 *   Stephane Delcroix <stephane@delcroix.org>
 *
 * Copyright (C) 2006 Stephane Delcroix
 */


using System;
using System.Collections;
using Mono.Posix;

using FSpot;
using FSpot.Extensions;

namespace FSpot.Extensions {

	public class DefaultImporterExtension: FSpot.Extensions.Extension
	{
		protected override string ConfigurationName { get { return "DefaultImporterExtension"; } }
		public override string DisplayName { get { return "Default Importer Extension"; } }
		public override string Description { get { return "This extension check if F-Spot is the default handler when a camera is connected. If not, it asks the user."; } }
		public override ExtensionCategory Category { get { return ExtensionCategory.Misc; } }
		public override ExtensionRevision Revision { get { return new ExtensionRevision(0, 1, 1); } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix"
				};
			} 
		}

		public DefaultImporterExtension () : base()
		{
			Console.WriteLine("new DIE instanciated !");	

			//Enable that preference by default at the first time
			bool enabled = (bool)Preferences.Get("Enabled", true);

			if (enabled && !DefaultHandler()) {
				DefaultImporterDialog did = new DefaultImporterDialog();
				did.do_button.Clicked += SetFSpotAsDefault;
				did.disable_check.Toggled += HandleEnableCheckToggled;
			}
		}

		protected override void ExtensionInitialize()
		{
			//Nothing to do here...
		}

		protected override void ExtensionDispose()
		{
			//Nothing to do here...
		}

		const string AUTOPHOTO = "/desktop/gnome/volume_manager/autophoto";
		const string AUTOPHOTO_COMMAND = "/desktop/gnome/volume_manager/autophoto_command";
		const string FSPOT_COMMAND = "f-spot-import %s";

		private bool DefaultHandler()
		{
			try {
				if (! (bool)FSpot.Preferences.Client.Get (AUTOPHOTO))
					return false;
				string current_command = FSpot.Preferences.Client.Get (AUTOPHOTO_COMMAND) as string;
				if (current_command != FSPOT_COMMAND)
					return false;
			} catch (GConf.NoSuchKeyException) {
				Console.WriteLine("Error while getting info from gconf");
				return false;
			}

			return true;
		}
		private void SetFSpotAsDefault(object o, EventArgs e)
		{
			FSpot.Preferences.Client.Set (AUTOPHOTO, true);
			FSpot.Preferences.Client.Set (AUTOPHOTO_COMMAND, FSPOT_COMMAND);
		}

		private void HandleEnableCheckToggled(object o, EventArgs e)
		{
			if (((Gtk.CheckButton)o).Active)
				Preferences.Set("Enabled", false);
			else
				Preferences.Set("Enabled", true);
		}
	}

	public class DefaultImporterDialog
	{
		private string dialog_name = "importer_dialog";
		private Glade.XML xml;
		private Gtk.Dialog dialog;

		[Glade.Widget] internal Gtk.Button do_button;
		[Glade.Widget] internal Gtk.CheckButton disable_check;

		public DefaultImporterDialog()
		{
			CreateDialog();
			Dialog.Modal = false;
			Dialog.TransientFor = null;
			
			Dialog.ShowAll();
			Dialog.Response += HandleResponse;
		}

		private void CreateDialog()
		{
			xml = new Glade.XML (null, "defaultimporterdialog.glade", dialog_name, "f-spot");
			xml.Autoconnect (this);
		}

		private Gtk.Dialog Dialog {
			get {
				if (dialog == null)
					dialog = (Gtk.Dialog) xml.GetWidget (dialog_name);
				return dialog;
			}
		}

		private void HandleResponse (object sender, Gtk.ResponseArgs args)
		{
			Dialog.Destroy();
		}
	}
}
