/* 
 * UserDirectoryExtension.cs
 *
 * Author(s)
 * 	Stephane Delcroix <stephane@delcroix.org>
 *
 */

using System;

using FSpot;
using FSpot.Extensions;

namespace FSpot.Extensions {

	public class UserDirectoryExtension: FSpot.Extensions.Extension
	{
		protected override string ConfigurationName { get { return "UserDirectoryExtension"; } }
		public override string DisplayName { get { return "User Extension Directory Plug-in"; } }
		public override string Description { get { return "This Extension add a new user directory for extensions"; } }
		public override ExtensionCategory Category { get { return ExtensionCategory.Misc; } }
		public override ExtensionRevision Revision { get { return new ExtensionRevision (0, 2, 0); } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix"
				};
			} 
		}

		public UserDirectoryExtension () : base()
		{
			Console.WriteLine("new UD-Extension instanciated !");	
			Preferences.Get("Enabled", true);
		}


		protected override void ExtensionInitialize()
		{
			Console.WriteLine("Initializing UD-Extension");
			ExtensionCore.Factory.AddScanDirectory(System.IO.Path.Combine(Global.BaseDirectory, "extensions"));
			ExtensionCore.Reload();
		}

		protected override void ExtensionDispose()
		{
			Console.WriteLine("Need to re-start F-Spot to disable this plug-in");
		}
	}
}
