/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * Jackson diagram -  adapted by Christophe Ponsard
 * This class captures all kind of domains (given, designed, machine)
 * both for sissi_object problems and for problem frames (ie. with domain kinds)
 *
 * based on SADT diagrams copyright (C) 2000, 2001 Cyrille Chepelov
 *
 * Forked from Flowchart toolbox -- objects for drawing flowcharts.
 * Copyright (C) 1999 James Henstridge.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
                
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "plug-ins.h"

#include "object.h"

#include "intl.h"
#include "sissi.h"
#include "sissi_dialog.h"


#include "element.h"
#include "connectionpoint.h"
#include "diarenderer.h"
#include "attributes.h"
#include "text.h"
#include "widgets.h"
#include "message.h"
#include "connpoint_line.h"
#include "color.h"
#include <string.h>

#define DEFAULT_WIDTH  1.0
#define DEFAULT_HEIGHT 1.0
#define TEXT_FONT (DIA_FONT_SANS|DIA_FONT_BOLD)
#define TEXT_FONT_HEIGHT 0.6
#define TEXT_HEIGHT (2.0)
#define NUM_CONNECTIONS 9


extern DiaObjectType sissi_object_type;
extern DiaObjectType room_type;
extern DiaObjectType faraday_type;
extern DiaObjectType zone_type;
extern DiaObjectType site_type;

DIA_PLUGIN_CHECK_INIT

PluginInitResult
dia_plugin_init(PluginInfo *info)
{
  if (!dia_plugin_info_init(info, "SISSI", _("SISSI diagram"),
			    NULL, NULL))
    return DIA_PLUGIN_INIT_ERROR;

  object_register_type(&sissi_object_type);
  object_register_type(&room_type);
  object_register_type(&faraday_type);
  object_register_type(&zone_type);
  object_register_type(&site_type);
      
  return DIA_PLUGIN_INIT_OK;
}

extern GtkWidget *object_sissi_get_properties_dialog(ObjetSISSI *object_sissi, gboolean is_default);
extern ObjectChange *object_sissi_apply_properties_dialog(ObjetSISSI *object_sissi);


void url_doc_write(AttributeNode attr_node, Url_Docs *url_docs)
{
  DataNode composite;

  composite = data_add_composite(attr_node, "url_doc");

  data_add_string(composite_add_attribute(composite, "label"), url_docs->label);
  data_add_string(composite_add_attribute(composite, "url"), url_docs->url);
  data_add_string(composite_add_attribute(composite, "description"), url_docs->description);

}

void propriete_menace_write(AttributeNode attr_node, Propriete_Menace *proprietes_menaces)
{
  DataNode composite;

  composite = data_add_composite(attr_node, "propriete_menace");

  data_add_string(composite_add_attribute(composite, "label"), proprietes_menaces->label);
  data_add_real(composite_add_attribute(composite, "action"), proprietes_menaces->action);
  data_add_real(composite_add_attribute(composite, "detection"), proprietes_menaces->detection);
  data_add_real(composite_add_attribute(composite, "vulnerability"), proprietes_menaces->vulnerability);
  data_add_string(composite_add_attribute(composite, "comments"), proprietes_menaces->comments);
}

void propriete_autre_write(AttributeNode attr_node, Propriete *proprietes_autre)
{
  DataNode composite;

  composite = data_add_composite(attr_node, "propriete_autre");

  data_add_string(composite_add_attribute(composite, "label"), proprietes_autre->label);
  data_add_string(composite_add_attribute(composite, "value"), proprietes_autre->value);
  data_add_string(composite_add_attribute(composite, "description"), proprietes_autre->description);
}

void propriete_url_write(AttributeNode attr_node, Url_Docs *url_docs)
{
  DataNode composite;

  composite = data_add_composite(attr_node, "propriete_url");

  data_add_string(composite_add_attribute(composite, "label"), url_docs->label);
  data_add_string(composite_add_attribute(composite, "url"), url_docs->url);
  data_add_string(composite_add_attribute(composite, "description"), url_docs->description);
}

void object_sissi_save(ObjetSISSI *object_sissi, ObjectNode obj_node, const char *filename)
{
  Propriete_Menace *proprietes_menaces;
  Propriete *proprietes_autres;
  Url_Docs *url_doc;
  GList *list;
  AttributeNode menace_node;
  AttributeNode propriete_node;  
  AttributeNode doc_node;
  element_save(&object_sissi->element, obj_node);

  data_add_string(new_attribute(obj_node, "name"), object_sissi->name);
  data_add_int(new_attribute(obj_node, "subscribers"),object_sissi->subscribers);
  data_add_boolean(new_attribute(obj_node, "show_background"), object_sissi->show_background);
  data_add_boolean(new_attribute(obj_node, "draw_border"), object_sissi->draw_border);
  data_add_boolean(new_attribute(obj_node, "keep_aspect"), object_sissi->keep_aspect);
  data_add_color(new_attribute(obj_node, "fill_colour"), &object_sissi->fill_colour);
  data_add_color(new_attribute(obj_node, "line_colour"), &object_sissi->line_colour);
  data_add_color(new_attribute(obj_node, "border_color"), &object_sissi->border_color);
  data_add_real (new_attribute (obj_node, "radius"), object_sissi->radius);
  data_add_real (new_attribute (obj_node, "dashlength"), object_sissi->dashlength);
  data_add_real (new_attribute (obj_node, "border_width"), object_sissi->border_width);
  data_add_real (new_attribute (obj_node, "line_width"), object_sissi->line_width);
  data_add_string(new_attribute(obj_node, "file_image"), object_sissi->file);
  data_add_string(new_attribute(obj_node, "confidentialite"), object_sissi->confidentialite);
  data_add_string(new_attribute(obj_node, "integrite"), object_sissi->integrite);
  data_add_string(new_attribute(obj_node, "disponibilite_echelle"), object_sissi->disponibilite_echelle);
  data_add_real (new_attribute (obj_node, "disponibilite_valeur"), object_sissi->disponibilite_valeur);
  data_add_string(new_attribute(obj_node, "id_db"), object_sissi->id_db);
  data_add_string(new_attribute(obj_node, "entite"), object_sissi->entite);
  data_add_string(new_attribute(obj_node, "entite_type"), object_sissi->entite_type);
  data_add_string(new_attribute(obj_node, "type_element"), object_sissi->type_element);
  data_add_string(new_attribute(obj_node, "room"), object_sissi->room);
  data_add_string(new_attribute(obj_node, "site"), object_sissi->site);
  data_add_int(new_attribute(obj_node, "nb_autres_fixes"),object_sissi->nb_autres_fixes);  
/*
  //   LineStyle 		line_style;   // comment faire ??????
//   ConnectionPoint 	connections[8]; // comment faire ??????
//  Text 			*text;  // comment faire ??????
*/
    /******* save other properties *************/
  propriete_node = new_attribute(obj_node, "proprietes");
  list = object_sissi->proprietes_autres;
  while (list != NULL) {
    proprietes_autres = (Propriete *) list->data;
    propriete_autre_write(propriete_node, proprietes_autres);
    list = g_list_next(list);
  }

  
  /******** save of menaces **********/
  menace_node = new_attribute(obj_node, "menaces");
  list = object_sissi->proprietes_menaces;
  while (list != NULL) {
    proprietes_menaces = (Propriete_Menace *) list->data;
    propriete_menace_write(menace_node, proprietes_menaces);
    list = g_list_next(list);
  }
  
  /******** save of urls_doc *********/
  doc_node = new_attribute(obj_node, "documentation");
  list = object_sissi->url_docs;
  while (list != NULL) {
  fprintf(stderr,"espion object_sissi_save fin\n");
    url_doc = (Url_Docs *) list->data;
    propriete_url_write(doc_node, url_doc);
    list = g_list_next(list);
  }
}

 real object_sissi_distance_from(ObjetSISSI *object_sissi, Point *point)
{
  Element *elem = &object_sissi->element;
  Rectangle rect;
  rect.left = elem->corner.x - object_sissi->border_width;
  rect.right = elem->corner.x + elem->width + object_sissi->border_width;
  rect.top = elem->corner.y - object_sissi->border_width;
  rect.bottom = elem->corner.y + elem->height + object_sissi->border_width;
  return distance_rectangle_point(&rect, point);
}

 void object_sissi_select(ObjetSISSI *object_sissi, Point *clicked_point, DiaRenderer *interactive_renderer)
{
/*
  //text_set_cursor(pc->text, clicked_point, interactive_renderer);
  //text_grab_focus(pc->text, &pc->element.object);
*/
  element_update_handles(&object_sissi->element);
}

ObjectChange* object_sissi_move_handle(ObjetSISSI *object_sissi, Handle *handle, Point *to, ConnectionPoint *cp, HandleMoveReason reason, ModifierKeys modifiers)
{
  AnchorShape horiz = ANCHOR_MIDDLE, vert = ANCHOR_MIDDLE;
  assert(object_sissi!=NULL);
  assert(handle!=NULL);
  assert(to!=NULL);

  element_move_handle(&object_sissi->element, handle->id, to, cp, reason, modifiers);

  switch (handle->id) {
  case HANDLE_RESIZE_NW:
    horiz = ANCHOR_END; vert = ANCHOR_END; break;
  case HANDLE_RESIZE_N:
    vert = ANCHOR_END; break;
  case HANDLE_RESIZE_NE:
    horiz = ANCHOR_START; vert = ANCHOR_END; break;
  case HANDLE_RESIZE_E:
    horiz = ANCHOR_START; break;
  case HANDLE_RESIZE_SE:
    horiz = ANCHOR_START; vert = ANCHOR_START; break;
  case HANDLE_RESIZE_S:
    vert = ANCHOR_START; break;
  case HANDLE_RESIZE_SW:
    horiz = ANCHOR_END; vert = ANCHOR_START; break;
  case HANDLE_RESIZE_W:
    horiz = ANCHOR_END; break;
  default:
    break;
  }

  object_sissi_update_data(object_sissi, horiz, vert);

  return NULL;
}

 ObjectChange* object_sissi_move(ObjetSISSI *object_sissi, Point *to)
{
  object_sissi->element.corner = *to;

  object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);
  return NULL;
}
/************ draw method ***********/
 void object_sissi_draw(ObjetSISSI *object_sissi, DiaRenderer *renderer)
{
 DiaRendererClass *renderer_ops = DIA_RENDERER_GET_CLASS (renderer);
 Point ul_corner, lr_corner, text_corner;
 Element *elem;
 real idfontheight;
 idfontheight=5.0;
  assert(object_sissi != NULL);
  assert(renderer != NULL);

  /********** computing positions ****************/
  elem = &object_sissi->element;

  lr_corner.x = elem->corner.x + elem->width + object_sissi->border_width/2;
  lr_corner.y = elem->corner.y + elem->height-TEXT_FONT_HEIGHT + object_sissi->border_width/2;
  
  ul_corner.x = elem->corner.x - object_sissi->border_width/2;
  ul_corner.y = elem->corner.y - object_sissi->border_width/2;

  text_corner.x = elem->corner.x - object_sissi->border_width/2;
  text_corner.y = elem->corner.y + elem->height + object_sissi->border_width/2;

  renderer_ops->draw_rect(renderer, 
		     &ul_corner,
		     &lr_corner, 
		     &object_sissi->border_color);
  
  renderer_ops->set_dashlength(renderer, object_sissi->dashlength);
  if (!object_sissi->show_background)
  {
   	renderer_ops->fill_rect(renderer, 
		       &elem->corner,
		       &lr_corner, 
		       &object_sissi->fill_colour);
  }
  if (object_sissi->image) {
    renderer_ops->draw_image(renderer, &elem->corner, elem->width, elem->height-TEXT_FONT_HEIGHT, object_sissi->image);
    renderer_ops->set_linejoin(renderer, LINEJOIN_MITER);
  } else {
/*
//     DiaImage broken = dia_image_get_broken();
//     renderer_ops->draw_image(renderer, &elem->corner, elem->width, elem->height, broken);
*/
  }
    text_set_position(object_sissi->text,&text_corner);
    text_set_string(object_sissi->text,object_sissi->name);
    text_draw(object_sissi->text, renderer);
}

 void object_sissi_update_data(ObjetSISSI *object_sissi, AnchorShape horiz, AnchorShape vert)
{
  Element *elem = &object_sissi->element;
  ElementBBExtras *extra = &elem->extra_spacing;
  DiaObject *obj = &elem->object;
  real width, height;
  Point center, bottom_right;
/***   save starting points ***********/
  center = bottom_right = elem->corner;
  center.x += elem->width/2;
  bottom_right.x += elem->width;
  center.y += elem->height/2;
  bottom_right.y += elem->height;

  object_sissi->connections[0].pos = elem->corner;
  object_sissi->connections[1].pos.x = elem->corner.x + elem->width / 2.0;
  object_sissi->connections[1].pos.y = elem->corner.y;
  object_sissi->connections[2].pos.x = elem->corner.x + elem->width;
  object_sissi->connections[2].pos.y = elem->corner.y;
  object_sissi->connections[3].pos.x = elem->corner.x;
  object_sissi->connections[3].pos.y = elem->corner.y + (elem->height-TEXT_FONT_HEIGHT) / 2.0;
  object_sissi->connections[4].pos.x = elem->corner.x + elem->width;
  object_sissi->connections[4].pos.y = elem->corner.y + (elem->height-TEXT_FONT_HEIGHT) / 2.0;
  object_sissi->connections[5].pos.x = elem->corner.x;
  object_sissi->connections[5].pos.y = elem->corner.y + elem->height-TEXT_FONT_HEIGHT;
  object_sissi->connections[6].pos.x = elem->corner.x + elem->width / 2.0;
  object_sissi->connections[6].pos.y = elem->corner.y + elem->height-TEXT_FONT_HEIGHT;
  object_sissi->connections[7].pos.x = elem->corner.x + elem->width;
  object_sissi->connections[7].pos.y = elem->corner.y + elem->height-TEXT_FONT_HEIGHT;
  object_sissi->connections[8].pos.x = elem->corner.x + elem->width / 2.0;
  object_sissi->connections[8].pos.y = elem->corner.y + (elem->height-TEXT_FONT_HEIGHT) / 2.0;

  object_sissi->connections[0].directions = DIR_NORTH|DIR_WEST;
  object_sissi->connections[1].directions = DIR_NORTH;
  object_sissi->connections[2].directions = DIR_NORTH|DIR_EAST;
  object_sissi->connections[3].directions = DIR_WEST;
  object_sissi->connections[4].directions = DIR_EAST;
  object_sissi->connections[5].directions = DIR_SOUTH|DIR_WEST;
  object_sissi->connections[6].directions = DIR_SOUTH;
  object_sissi->connections[7].directions = DIR_SOUTH|DIR_EAST;
  object_sissi->connections[8].directions = DIR_ALL;

/*
//   if (width > elem->width) elem->width = width;
//   if (height > elem->height) elem->height = height;
//   text_set_position(object_sissi->text,&object_sissi->labelstart);
  //move shape if necessary ... 
*/
  switch (horiz) {
    case ANCHOR_MIDDLE:
      elem->corner.x = center.x - elem->width/2; break;
    case ANCHOR_END:
      elem->corner.x = bottom_right.x - elem->width; break;
    default:
      break;
  }

  switch (vert) {
    case ANCHOR_MIDDLE:
      elem->corner.y = center.y - elem->height/2; break;
    case ANCHOR_END:
      elem->corner.y = bottom_right.y - elem->height; break;
    default:
      break;
  }
  extra->border_trans = object_sissi->border_width / 2.0;
  element_update_boundingbox(elem);

  obj->position = elem->corner;
  
  element_update_handles(elem);
 }
 
 /*********** copy function **********/
 DiaObject *object_sissi_copy_using_properties(ObjetSISSI *object_sissi_origine)
 {
  ObjetSISSI *object_sissi;
  Element *elem,*elem_origine;
  DiaObject *obj;
  int i;
  GList *list;
  Propriete_Menace *proprietes_menaces_aux;
  Propriete *propriete_aux;
  Url_Docs *url_aux;
  DiaFont* action_font;
  Point defaultlen  = {1.0,0.0}, pos;
 
  elem_origine = &object_sissi_origine->element; 
  
  object_sissi = g_malloc0(sizeof(ObjetSISSI));
  elem = &object_sissi->element;
  obj = &elem->object;
  element_copy(elem_origine, elem);
  action_font = dia_font_new_from_style(TEXT_FONT,TEXT_FONT_HEIGHT); 
  object_sissi->text = new_text("",action_font, TEXT_FONT_HEIGHT, &pos, &color_black, ALIGN_LEFT);
  
  object_sissi->nb_autres_fixes=object_sissi_origine->nb_autres_fixes;

   object_sissi->border_color=object_sissi_origine->border_color;
   object_sissi->fill_colour=object_sissi_origine->fill_colour; 
   object_sissi->radius=object_sissi_origine->radius;
   object_sissi->subscribers=object_sissi_origine->subscribers; 
   object_sissi->show_background=object_sissi_origine->show_background;
   object_sissi->line_colour=object_sissi_origine->line_colour; 
   object_sissi->dashlength=object_sissi_origine->dashlength;
   object_sissi->line_width=object_sissi_origine->line_width; 
   object_sissi->border_width=object_sissi_origine->border_width;
   object_sissi->draw_border=object_sissi_origine->draw_border; 
   object_sissi->keep_aspect=object_sissi_origine->keep_aspect;

   object_sissi->confidentialite = g_strdup(object_sissi_origine->confidentialite);
   object_sissi->entite = g_strdup(object_sissi_origine->entite);
   object_sissi->entite_type = g_strdup(object_sissi_origine->entite_type);
   object_sissi->site = g_strdup(object_sissi_origine->site);
   object_sissi->room = g_strdup(object_sissi_origine->room);
   object_sissi->name = g_strdup(object_sissi_origine->name);
      
   object_sissi->type_element = g_strdup(object_sissi_origine->type_element);
   object_sissi->file =g_strdup(object_sissi_origine->file);
   object_sissi->image = dia_image_load(dia_get_data_directory(object_sissi->file));
  
  for (i=0;i<NUM_CONNECTIONS;i++) {
    obj->connections[i] = &object_sissi->connections[i];
    object_sissi->connections[i].object = obj;
    object_sissi->connections[i].connected = NULL;
  }
    
  /*** copy menaces list */
  object_sissi->proprietes_menaces = NULL;
  list = object_sissi_origine->proprietes_menaces;
  while (list != NULL) {
    proprietes_menaces_aux = (Propriete_Menace *)list->data;   
    object_sissi->proprietes_menaces = g_list_prepend(object_sissi->proprietes_menaces, copy_menace(proprietes_menaces_aux->label,proprietes_menaces_aux->comments,proprietes_menaces_aux->action,proprietes_menaces_aux->detection,proprietes_menaces_aux->vulnerability));
    list = g_list_next(list);
  }
  
 /*********** copy the other propertie */
  object_sissi->proprietes_autres = NULL;
  list = object_sissi_origine->proprietes_autres;
  while (list != NULL) {
    propriete_aux = (Propriete *)list->data;   
    object_sissi->proprietes_autres = g_list_prepend(object_sissi->proprietes_autres, create_new_propriete_autre(propriete_aux->label,propriete_aux->description,propriete_aux->value));
    list = g_list_next(list);
  }
/*********** copy the list of documents */
  object_sissi->url_docs = NULL;
  list = object_sissi_origine->url_docs;
  while (list != NULL) {
    url_aux = (Url_Docs *)list->data;   
    object_sissi->proprietes_autres = g_list_prepend(object_sissi->url_docs, create_new_url(url_aux->label,url_aux->description,url_aux->url));
    list = g_list_next(list);
  }
  
  object_sissi_update_data(object_sissi, ANCHOR_MIDDLE, ANCHOR_MIDDLE);
  
  return &object_sissi->element.object;
    
}
 
 void object_sissi_destroy(ObjetSISSI *object_sissi)
{
  g_free(object_sissi->file);  
  g_free(object_sissi->confidentialite);  
  g_free(object_sissi->integrite);  
  g_free(object_sissi->disponibilite_echelle);
  g_free(object_sissi->entite);  
  g_free(object_sissi->entite_type);  
  g_free(object_sissi->type_element);  
  g_free(object_sissi->room);  
  g_free(object_sissi->site); 
  g_free(object_sissi->name); 
  
  if (object_sissi->properties_dialog!=NULL)
  	dialog_sissi_destroy(object_sissi->properties_dialog);
	
  object_sissi->proprietes_menaces=vidage_liste_propriete_menace(object_sissi->proprietes_menaces);
  object_sissi->proprietes_autres=vidage_liste_propriete(object_sissi->proprietes_autres);
  object_sissi->url_docs=vidage_liste_url_doc(object_sissi->url_docs); 
  /* text_destroy(pc->text); */
  element_destroy(&object_sissi->element);
}

void dialog_sissi_destroy(SISSIDialog *properties_dialog)
{
  gtk_widget_destroy(properties_dialog->dialog);
}

Propriete_Menace *propriete_menace_read(DataNode composite)
{
  Propriete_Menace *proprietes_menaces;
  AttributeNode attr_node;
  
  proprietes_menaces = g_malloc0(sizeof(Propriete_Menace));

  proprietes_menaces->label = NULL;
  attr_node = composite_find_attribute(composite, "label");
  if (attr_node != NULL)
    proprietes_menaces->label =  data_string( attribute_first_data(attr_node) );

  proprietes_menaces->action = 0;
  attr_node = composite_find_attribute(composite, "action");
  if (attr_node != NULL)
     proprietes_menaces->action =  data_real( attribute_first_data(attr_node) );

  proprietes_menaces->detection = 0;
  attr_node = composite_find_attribute(composite, "detection");
  if (attr_node != NULL)
     proprietes_menaces->detection =  data_real( attribute_first_data(attr_node) );

  proprietes_menaces->vulnerability = 0;
  attr_node = composite_find_attribute(composite, "vulnerability");
  if (attr_node != NULL)
    proprietes_menaces->vulnerability =  data_real( attribute_first_data(attr_node) );

  proprietes_menaces->comments = NULL;
  attr_node = composite_find_attribute(composite, "comments");
  if (attr_node != NULL)
    proprietes_menaces->comments = data_string(attribute_first_data(attr_node));

  return proprietes_menaces;
}

Propriete *propriete_autre_read(DataNode composite)
{
  Propriete *proprietes_autres;
  AttributeNode attr_node;
  
  proprietes_autres = g_malloc0(sizeof(Propriete));

  proprietes_autres->label = NULL;
  attr_node = composite_find_attribute(composite, "label");
  if (attr_node != NULL)
    proprietes_autres->label = data_string( attribute_first_data(attr_node) );

  proprietes_autres->value = NULL;
  attr_node = composite_find_attribute(composite, "value");
  if (attr_node != NULL)
    proprietes_autres->value = data_string( attribute_first_data(attr_node) );

  proprietes_autres->description = NULL;
  attr_node = composite_find_attribute(composite, "description");
  if (attr_node != NULL)
    proprietes_autres->description = data_string( attribute_first_data(attr_node) );
  
  if (!strcmp(proprietes_autres->description,""))
  	proprietes_autres->description=NULL;
	
  return proprietes_autres;
}

Url_Docs *url_doc_read(DataNode composite)
{
  Url_Docs *url_doc;
  AttributeNode attr_node;
  
  url_doc = g_malloc0(sizeof(Propriete));

  url_doc->label = NULL;
  attr_node = composite_find_attribute(composite, "label");
  if (attr_node != NULL)
    url_doc->label =  data_string( attribute_first_data(attr_node) );

  url_doc->url = NULL;
  attr_node = composite_find_attribute(composite, "url");
  if (attr_node != NULL)
    url_doc->url =  data_string( attribute_first_data(attr_node) );

  url_doc->description = NULL;
  attr_node = composite_find_attribute(composite, "description");
  if (attr_node != NULL)
    url_doc->description =  data_string( attribute_first_data(attr_node) );

  return url_doc;
}


ObjetSISSI *object_sissi_load(ObjectNode obj_node, int version, const char *filename, ObjetSISSI *object_sissi,Element *elem,DiaObject *obj)
{
  Propriete_Menace *proprietes_menaces;
  Propriete *proprietes_autres;
  Url_Docs *url_doc;
  AttributeNode attr_node;
  DataNode composite;
  int i;
  int num;

/*   object_sissi = g_malloc0(sizeof(ObjetSISSI)); */
   elem = &object_sissi->element;
   obj = &elem->object;
  
   element_load(elem, obj_node);
  /* object_load_props(obj,obj_node); */

    element_init(elem, 8, NUM_CONNECTIONS);
  for (i=0;i<NUM_CONNECTIONS;i++) {
      obj->connections[i] = &object_sissi->connections[i];
     object_sissi->connections[i].object = obj;
     object_sissi->connections[i].connected = NULL;
   }

  /* a bunch of properties still need their own special handling 

  // r�up des donn�s: */
  object_sissi->name = NULL;
  attr_node = object_find_attribute(obj_node, "name");
  if (attr_node != NULL)
    object_sissi->name =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->file = NULL;
  attr_node = object_find_attribute(obj_node, "file_image");
  if (attr_node != NULL)
    object_sissi->file =  data_string( attribute_first_data(attr_node) );
 
  attr_node = object_find_attribute(obj_node, "subscribers");
  if (attr_node != NULL)
    object_sissi->subscribers = data_int(attribute_first_data(attr_node));

  object_sissi->show_background = FALSE;
  attr_node = object_find_attribute(obj_node, "show_background");
  if (attr_node != NULL)
    object_sissi->show_background = data_boolean(attribute_first_data(attr_node));

  object_sissi->show_background = FALSE;
  attr_node = object_find_attribute(obj_node, "draw_border");
  if (attr_node != NULL)
    object_sissi->draw_border = data_boolean(attribute_first_data(attr_node));

  object_sissi->keep_aspect = FALSE;
  attr_node = object_find_attribute(obj_node, "keep_aspect");
  if (attr_node != NULL)
    object_sissi->keep_aspect = data_boolean(attribute_first_data(attr_node));
 
  object_sissi->fill_colour = color_white;
  attr_node = object_find_attribute(obj_node, "fill_colour");
  if(attr_node != NULL)
    data_color(attribute_first_data(attr_node), &object_sissi->fill_colour); 
 
  object_sissi->line_colour = color_black;
  attr_node = object_find_attribute(obj_node, "line_colour");
  if(attr_node != NULL)
    data_color(attribute_first_data(attr_node), &object_sissi->line_colour); 

  object_sissi->border_color = color_black;
  attr_node = object_find_attribute(obj_node, "border_color");
  if(attr_node != NULL)
    data_color(attribute_first_data(attr_node), &object_sissi->border_color); 

  attr_node = object_find_attribute(obj_node, "radius");
  if (attr_node != NULL)
    object_sissi->radius = data_real(attribute_first_data(attr_node));
  
  attr_node = object_find_attribute(obj_node, "dashlength");
  if (attr_node != NULL)
    object_sissi->dashlength = data_real(attribute_first_data(attr_node));
  
  attr_node = object_find_attribute(obj_node, "border_width");
  if (attr_node != NULL)
    object_sissi->border_width = data_real(attribute_first_data(attr_node));
  
  attr_node = object_find_attribute(obj_node, "line_width");
  if (attr_node != NULL)
    object_sissi->line_width = data_real(attribute_first_data(attr_node));
    
  object_sissi->id_db = NULL;
  attr_node = object_find_attribute(obj_node, "id_db");
  if (attr_node != NULL)
    object_sissi->id_db =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->confidentialite = NULL;
  attr_node = object_find_attribute(obj_node, "confidentialite");
  if (attr_node != NULL)
    object_sissi->confidentialite =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->integrite = NULL;
  attr_node = object_find_attribute(obj_node, "integrite");
  if (attr_node != NULL)
    object_sissi->integrite =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->disponibilite_echelle = NULL;
  attr_node = object_find_attribute(obj_node, "disponibilite_echelle");
  if (attr_node != NULL)
    object_sissi->disponibilite_echelle =  data_string( attribute_first_data(attr_node) );
  
  attr_node = object_find_attribute(obj_node, "disponibilite_valeur");
  if (attr_node != NULL)
    object_sissi->disponibilite_valeur = data_real(attribute_first_data(attr_node));
  
  object_sissi->entite = NULL;
  attr_node = object_find_attribute(obj_node, "entite");
  if (attr_node != NULL)
    object_sissi->entite =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->entite_type = NULL;
  attr_node = object_find_attribute(obj_node, "entite_type");
  if (attr_node != NULL)
    object_sissi->entite_type =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->type_element = NULL;
  attr_node = object_find_attribute(obj_node, "type_element");
  if (attr_node != NULL)
    object_sissi->type_element =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->room = NULL;
  attr_node = object_find_attribute(obj_node, "room");
  if (attr_node != NULL)
    object_sissi->room =  data_string( attribute_first_data(attr_node) );
  
  object_sissi->site = NULL;
  attr_node = object_find_attribute(obj_node, "site");
  if (attr_node != NULL)
    object_sissi->site =  data_string( attribute_first_data(attr_node) );

   attr_node = object_find_attribute(obj_node, "nb_autres_fixes");
  if (attr_node != NULL)
    object_sissi->nb_autres_fixes = data_int(attribute_first_data(attr_node));
 
  /**** read the other proprietes *******/
  attr_node = object_find_attribute(obj_node, "proprietes");
  num = attribute_num_data(attr_node);
  composite = attribute_first_data(attr_node);
  object_sissi->proprietes_autres = NULL;
  for (i=0;i<num;i++) {
    proprietes_autres = propriete_autre_read(composite);
    object_sissi->proprietes_autres = g_list_append(object_sissi->proprietes_autres, proprietes_autres);
    composite = data_next(composite);
  }

  
  /******** read the menaces properties ************/
  attr_node = object_find_attribute(obj_node, "menaces");
  num = attribute_num_data(attr_node);
  composite = attribute_first_data(attr_node);
  object_sissi->proprietes_menaces = NULL;
  for (i=0;i<num;i++) {
    proprietes_menaces = propriete_menace_read(composite);
    object_sissi->proprietes_menaces = g_list_append(object_sissi->proprietes_menaces, proprietes_menaces);
    composite = data_next(composite);
  }

  /********* read the docs *************/
  attr_node = object_find_attribute(obj_node, "documentation");
  num = attribute_num_data(attr_node);
  composite = attribute_first_data(attr_node);
  object_sissi->url_docs = NULL;
  for (i=0;i<num;i++) {
    url_doc = url_doc_read(composite);
    object_sissi->url_docs = g_list_append(object_sissi->url_docs, url_doc);
    composite = data_next(composite);
  }

  return object_sissi;
}

GtkWidget *object_sissi_get_properties(ObjetSISSI *object_sissi, gboolean is_default)
{
    return object_sissi_get_properties_dialog(object_sissi, is_default);
}

void object_sissi_apply_properties(ObjetSISSI *object_sissi)
{
    object_sissi_apply_properties_dialog(object_sissi);
}

Propriete *create_new_propriete_autre(gchar *label, gchar *description, gchar *value)
{
  Propriete *propriete;
  propriete = g_new0(Propriete, 1);

  if (propriete->label != NULL)
    g_free(propriete->label);
  if (label && label[0])
    propriete->label = g_strdup (label);
  else
    propriete->label = NULL;

  if (propriete->description != NULL)
    g_free(propriete->description);
  if (description && description[0])
    propriete->description = g_strdup (description);
  else
    propriete->description = NULL;

  if (propriete->value != NULL)
    g_free(propriete->value);
  if (value && value[0])
    propriete->value = g_strdup (value);
  else
    propriete->value = NULL;
  
  return propriete;
}

Url_Docs *create_new_url(gchar *label, gchar *description, gchar *url)
{
  Url_Docs *url_doc;
  url_doc = g_new0(Url_Docs, 1);

  if (url_doc->label != NULL)
    g_free(url_doc->label);
  if (label && label[0])
    url_doc->label = g_strdup (label);
  else
    url_doc->label = NULL;

  if (url_doc->description != NULL)
    g_free(url_doc->description);
  if (description && description[0])
    url_doc->description = g_strdup (description);
  else
    url_doc->description = NULL;

  if (url_doc->url != NULL)
    g_free(url_doc->url);
  if (url && url[0])
    url_doc->url = g_strdup (url);
  else
    url_doc->url = NULL;
  
  return url_doc;
}


GList *vidage_liste_propriete (GList *list)
{  
  while (list != NULL) {
    Propriete *propriete = (Propriete *) list->data;
    g_free(propriete->label);
    g_free(propriete->value);
    g_free(propriete->description);
    g_free(propriete);
    list = g_list_next(list);
  }
   g_list_free(list);
   list=NULL;
  return list;
}

GList *vidage_liste_url_doc (GList *list)
{  
  while (list != NULL) {
    Url_Docs *url_doc = (Url_Docs *) list->data;
    g_free(url_doc->label);
    g_free(url_doc->url);
    g_free(url_doc->description);
    g_free(url_doc);
    list = g_list_next(list);
  }
  g_list_free(list);
  list=NULL;
  return list;
}
