/* Dia -- an diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * Jackson diagram -  adapted by Christophe Ponsard
 * This class captures all kind of domains (given, designed, machine)
 * both for generic problems and for problem frames (ie. with domain kinds)
 *
 * based on SADT diagrams copyright (C) 2000, 2001 Cyrille Chepelov
 *
 * Forked from Flowchart toolpc -- objects for drawing flowcharts.
 * Copyright (C) 1999 James Henstridge.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <string.h>
#include <glib.h>
#include "menace.h"

Propriete_Menace *copy_menace(gchar *label_menace,gchar *comments_menace,float action,float detection,float vulnerability)
{
  Propriete_Menace *propriete;
  propriete = g_new0(Propriete_Menace, 1);

/********** gestion of label ************/
  if (propriete->label != NULL)
    g_free(propriete->label);
  if (label_menace && label_menace[0])
    propriete->label = g_strdup (label_menace);
  else
    propriete->label = NULL;

/********** gestion of comments ************/
  if (propriete->comments != NULL)
    g_free(propriete->comments);
  if (comments_menace && comments_menace[0])
    propriete->comments = g_strdup (comments_menace);
  else
    propriete->comments = NULL;

  propriete->action=action;
  propriete->detection=detection;
  propriete->vulnerability=vulnerability;
  
  return propriete;

}

void create_new_proprietes_menace(gchar *label_menace, Propriete_Menace *propriete)
{
/*********** label **********/  
  if (propriete->label != NULL)
    g_free(propriete->label);
  
  if (label_menace && label_menace[0])
    propriete->label = g_strdup (label_menace);
  else
    propriete->label = NULL;
    
/*********** comments **********/
  if (propriete->comments != NULL)
    g_free(propriete->comments);
  propriete->comments = g_strdup ("");

 propriete->action=propriete->detection=propriete->vulnerability=0.0f;
}

GList *create_list_proprietes_menace(GList *list_propriete_menace, gchar *entite_type)
{

Propriete_Menace *propriete1,*propriete2,*propriete3,*propriete4,*propriete5,*propriete6,*propriete7,*propriete8,*propriete9,*propriete10;
Propriete_Menace *propriete11,*propriete12,*propriete13,*propriete14,*propriete15,*propriete16,*propriete17,*propriete18,*propriete19,*propriete20;
Propriete_Menace *propriete21,*propriete22,*propriete23,*propriete24,*propriete25,*propriete26,*propriete27,*propriete28,*propriete29,*propriete30;
Propriete_Menace *propriete31,*propriete32,*propriete33,*propriete34,*propriete35,*propriete36,*propriete37,*propriete38,*propriete39,*propriete40;
Propriete_Menace *propriete41,*propriete42;

/* fprintf(stderr,"espion create_list_proprietes_menace, %s \n",entite_type);*/

if(strcmp(entite_type,"PHYSIQUE")==0 || strcmp(entite_type,"PHY_DETECTION_FEU")==0|| strcmp(entite_type,"PHY_ACTION_FEU")==0)
{
 propriete1 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Fire", propriete1);
 list_propriete_menace = g_list_prepend(list_propriete_menace, propriete1);
} 
if(strcmp(entite_type,"PHYSIQUE")==0|| strcmp(entite_type,"PHY_DETECTION_EAU")==0|| strcmp(entite_type,"PHY_ACTION_EAU")==0)
{
 propriete2 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Water damage",propriete2);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete2);
}
if(strcmp(entite_type,"PHYSIQUE")==0|| strcmp(entite_type,"PHY_DETECTION_AIR")==0|| strcmp(entite_type,"PHY_ACTION_AIR")==0|| strcmp(entite_type,"PHY_DETECTION_EAU")==0|| strcmp(entite_type,"PHY_ACTION_EAU")==0)
{
 propriete3 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Pollution",propriete3);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete3);
}
if(strncmp(entite_type,"PHY",3)==0)
{
 propriete4 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Major accidents",propriete4);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete4);
}
if(strncmp(entite_type,"PHY",3)==0 || strcmp(entite_type,"RESEAU")==0 || strcmp(entite_type,"SYSTEME")==0 || strcmp(entite_type,"MATERIEL")==0)
{
 propriete5 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Materials or supports destroy",propriete5);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete5);
}
if(strncmp(entite_type,"PHY",3)==0)
{
 propriete6 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Climatic phenomenon",propriete6);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete6);
}
if(strcmp(entite_type,"PHYSIQUE")==0)
{
 propriete7 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Seismic phenomen",propriete7);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete7);
}
if(strcmp(entite_type,"PHYSIQUE")==0)
{
 propriete8 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Volcanic phenomen",propriete8);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete8);
}
if(strncmp(entite_type,"PHY",3)==0)
{
 propriete9 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Meteorological phenomen",propriete9);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete9);
}
if(strcmp(entite_type,"PHYSIQUE")==0 ||strcmp(entite_type,"PHY_DETECTION_EAU")==0 ||strcmp(entite_type,"PHY_ACTION_EAU")==0)
{
 propriete10 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Flood",propriete10);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete10);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"PHY_DETECTION_AIR")==0||strcmp(entite_type,"PHY_ACTION_AIR")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"PHYSIQUE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete11 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Failure of air-conditioning",propriete11);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete11);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete12 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Loss of power supply",propriete12);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete12);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete13 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Failure of telecommunication equipment",propriete13);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete13);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete14 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Electromagnetic radiation",propriete14);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete14);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete15 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Thermal radiations",propriete15);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete15);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete16 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Electromagnetic pulse (emp)",propriete16);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete16);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete17 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Interception of compromising interference signals",propriete17);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete17);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"PHYSIQUE")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete18 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Remote spying",propriete18);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete18);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"PHYSIQUE")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete19 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Eavesdropping",propriete19);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete19);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete20 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Theft of media or documents",propriete20);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete20);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete21 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Theft of equipment",propriete21);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete21);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strcmp(entite_type,"PHYSIQUE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete22 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Retrieval of recycled or discarded media",propriete22);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete22);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"PERSONNE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete23 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Disclosure",propriete23);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete23);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete24 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Data from untrustworthy sources",propriete24);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete24);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"PERSONNE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete25 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Tampering with hardware",propriete25);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete25);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"PERSONNE")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strncmp(entite_type,"PHY_ACTION",10)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete26 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Tampering with software",propriete26);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete26);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"PERSONNE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete27 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Position detection",propriete27);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete27);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0){
 propriete28 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Equipment failure",propriete28);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete28);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete29 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Equipment malfunction",propriete29);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete29);
}
if(strcmp(entite_type,"SYSTEME")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strncmp(entite_type,"PHY_ACTION",10)==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete30 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Saturation of the information system",propriete30);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete30);
}
if(strcmp(entite_type,"SYSTEME")==0||strncmp(entite_type,"PHY_DETECTION",13)==0||strncmp(entite_type,"PHY_ACTION",10)==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0)
{
 propriete31 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Software malfunction",propriete31);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete31);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete32 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Breach of information system maintainability",propriete32);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete32);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete33 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Unauthorised use of equipment",propriete33);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete33);
}
if(strcmp(entite_type,"LOGICIEL")==0)
{
 propriete34 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Fraudulent copying of software",propriete34);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete34);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0)
{
 propriete35 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Use of counterfeit or copied software",propriete35);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete35);
}
if(strncmp(entite_type,"PHY",3)==0)if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete36 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Corruption of data",propriete36);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete36);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"PERSONNE")==0||strncmp(entite_type,"PHY_",4)==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete37 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Illegal processing of data",propriete37);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete37);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"MATERIEL")==0||strncmp(entite_type,"PHY_",4)==0)
{
 propriete38 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Error in use",propriete38);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete38);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete39 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Abuse of rights",propriete39);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete39);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete40 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Forging of rights",propriete40);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete40);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strcmp(entite_type,"MATERIEL")==0||strncmp(entite_type,"PHY_",4)==0)
{
 propriete41 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Denial of actions",propriete41);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete41);
}
if(strcmp(entite_type,"SYSTEME")==0||strcmp(entite_type,"RESEAU")==0||strcmp(entite_type,"LOGICIEL")==0||strncmp(entite_type,"PHY",3)==0||strcmp(entite_type,"ORGANISATION")==0||strcmp(entite_type,"PERSONNE")==0||strcmp(entite_type,"MATERIEL")==0)
{
 propriete42 = g_malloc0(sizeof(Propriete_Menace));
 create_new_proprietes_menace("Breach of personnel availability",propriete42);
 list_propriete_menace = g_list_append(list_propriete_menace, propriete42);
}
  return list_propriete_menace;
}

GList *vidage_liste_propriete_menace (GList *list)
{  
  while (list != NULL) {
    Propriete_Menace *propriete_menace = (Propriete_Menace *) list->data;
    g_free(propriete_menace->label);
    g_free(propriete_menace->comments);/*
//     g_free(propriete_menace->action);
//     g_free(propriete_menace->detection);
//     g_free(propriete_menace->vulnerability);
*/
    g_free(propriete_menace);
    list = g_list_next(list);
  }
  g_list_free(list);
  return list;
}

GList *vidage_liste_propriete_menace_widget (GList *list)
{  
  while (list != NULL) {
    Propriete_Menace_Widget *propriete_menace = (Propriete_Menace_Widget *) list->data;
    gtk_widget_destroy(propriete_menace->label);
    gtk_widget_destroy(propriete_menace->comments);
    gtk_widget_destroy(propriete_menace->action);
    gtk_widget_destroy(propriete_menace->detection);
    gtk_widget_destroy(propriete_menace->vulnerability);
    g_free(propriete_menace);
    list = g_list_next(list);
  }
  g_list_free(list);
  return list;
}
