using System;

using FSpot;
using FSpot.Plugins;

namespace FSpot.Plugins {

	public class CDExportPlugin: FSpot.Plugins.ExportPlugin
	{
		protected override string ConfigurationName { get { return "CDExportPlugin"; } }
		public override string DisplayName { get { return "CDExport Plugin"; } }
		public override string Description { get { return "This Plugin exports to CD"; } }
		public override string MenuEntryName { get { return "Export to CD"; }}
		//public override PluginCategory Category { get { return PluginCategory.Misc; } }
		public override string [] Authors {
			get { 
				return new string [] {
					"FirstAuthor",
					"SecondGuy"
				};
			} 
		}

		public CDExportPlugin () : base()
		{
			Console.WriteLine("new CDExport Plugin instanciated !");	
			//This will enable this plugin at first load
			//Preferences.Get("Enabled", true);
			
			//This will enable this plugin at startup
			//Preferences.Set("Enabled", true);
		}

		protected override void Run()
		{
			new FSpot.CDExport(photos);
			Console.WriteLine ("Exporting {0} pictures to CD", photos.Count);	
		}

		protected override void PluginInitialize()
		{
			Console.WriteLine("Initializing CDExportPlugin");	
		}

		protected override void PluginDispose()
		{
			Console.WriteLine("Disposing CDExportPlugin");
		}
	}
}
