/*
 * gtkfilechooserbutton.c test the encoding of returned filename  
 */


#include <gtk/gtk.h>
#include <glib.h>
#include <locale.h>
#include <stdio.h>

static void
chooser_selection_changed_cb (GtkFileChooser *chooser, gpointer user_data)
{
	gchar *filename;

	filename = gtk_file_chooser_get_uri (chooser);
	printf ("test: %s::selection-changed\n\turi Selection: %s\n", G_OBJECT_TYPE_NAME (chooser), filename);

	g_free (filename);
	filename = NULL;

	filename = gtk_file_chooser_get_filename (chooser);
	printf ("test: %s::selection-changed\n\tfilename: %s\n", G_OBJECT_TYPE_NAME (chooser), filename);

	gchar *g_file_uri = g_filename_to_uri (filename, NULL, NULL);
	printf ("\tg_filename_to_uri: %s\n", g_file_uri);
	g_free (filename);
}

int
main (int argc, char **argv)
{
	GtkWidget *fc_button;
	GtkWidget *window;

	gtk_init (&argc, &argv);

	g_print ("Current locale is: %s\n", setlocale (LC_ALL, NULL));

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), "Test gtkfilechooserbutton");
	gtk_window_set_default_size (GTK_WINDOW (window), 300, 200);
	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);

	gtk_container_set_border_width (GTK_CONTAINER (window), 10);

	fc_button = gtk_file_chooser_button_new ("Select a file", GTK_FILE_CHOOSER_ACTION_OPEN);
	g_signal_connect (G_OBJECT (fc_button), "selection-changed",
			G_CALLBACK (chooser_selection_changed_cb), NULL);


	gtk_container_add (GTK_CONTAINER (window), fc_button);

	gtk_widget_show (fc_button);
	gtk_widget_show (window);

	gtk_main();

	return 0;
} 
	
