using System;

using FSpot;
using FSpot.Plugins;

namespace FSpot.Plugins {

	public class UserPluginDirectoryPlugin: FSpot.Plugins.Plugin
	{
		protected override string ConfigurationName { get { return "UserPluginDirectoryPlugin"; } }
		public override string DisplayName { get { return "User Plugin Directory Plug-in"; } }
		public override string Description { get { return "This Plugin add a new user directory for plugins"; } }
		public override PluginCategory Category { get { return PluginCategory.Misc; } }
		public override string [] Authors {
			get { 
				return new string [] {
					"Stephane Delcroix"
				};
			} 
		}

		public UserPluginDirectoryPlugin () : base()
		{
			Console.WriteLine("new UPD-Plugin instanciated !");	
			Preferences.Get("Enabled", true);
		}


		protected override void PluginInitialize()
		{
			Console.WriteLine("Initializing UPD-Plugin");
			PluginCore.Factory.AddScanDirectory(System.IO.Path.Combine(Global.BaseDirectory, "plugins"));
			PluginCore.Reload();
		}

		protected override void PluginDispose()
		{
			Console.WriteLine("Need to re-start F-Spot to disable this plug-in");
		}
	}
}
