/*
 * =====================================================================================
 * 
 *        Filename:  treeitem.c
 * 
 *     Description:  treeitem.c
 * 
 *         Version:  1.0
 *         Created:  02/15/06 21:45:56 CST
 *        Revision:  none
 *        Compiler:  gcc
 * 
 *          Author:  Boby.Wolf (BW), boby.wolf@sun.com
 *         Company:  ERI Of Sun, China
 * 
 * =====================================================================================
 */

#include "treeitem.h"
#include <string.h>

struct _TreeItemPrivate {
	const gchar* label;
	gboolean have_image;
	gboolean check_visible;
	gboolean toggle_last;
};

G_DEFINE_TYPE (TreeItem, tree_item, G_TYPE_OBJECT)

GObject *
tree_item_new (const gchar* label, gboolean have_image, gboolean check_visible, gboolean toggle_last)
{
	TreeItem *item;
	
	item = g_object_new (tree_item_get_type(), NULL);

	tree_item_init (item);
	item->priv->label = label;
	item->priv->have_image = have_image;
	item->priv->check_visible = check_visible;
	item->priv->toggle_last = toggle_last;

	return G_OBJECT (item);
}

static void
tree_item_init (TreeItem* item)
{
	item->priv = g_new0 (TreeItemPrivate, 1);
}

static void
tree_item_class_init (TreeItemClass* itemclass)
{
}

const gchar* tree_item_get_label (TreeItem *item)
{
	return item->priv->label;
}

gboolean tree_item_have_image (TreeItem *item)
{
	return item->priv->have_image;
}

gboolean tree_item_check_visible (TreeItem *item)
{
	return item->priv->check_visible;
}

gboolean tree_item_toggle_last (TreeItem *item)
{
	return item->priv->toggle_last;
}

void tree_item_set_toggle (TreeItem *item)
{
	item->priv->toggle_last = (item->priv->toggle_last)? FALSE : TRUE;
}
