/***************************************************************************
****************************************************************************
*/
/**@file hudaqlib.h
*  Description: data acquisition library interface.
*
*
******************************************************************************
*****************************************************************************/
#ifndef HUDAQLIB_H__
#define HUDAQLIB_H__

/**
 * Move stepping motor to a target position. During a first time call it resets internal
 * position counter and sets 2 internal counters for driving one stepper motor.
 * @param[in] handle  Device handle.
 * @param[in] channel number of counter (0 - 1)
 * @param[in] TargetPosition Position to move stepping motor. (It is absolute position, not a difference.)
*/
HUDAQLIBPUBLIC void HUDAQAPI stepout(HUDAQHANDLE handle, unsigned channel, long TargetPosition);

#
endif  /* HUDAQLIB_H__ */
