///
/// \file actask.c
/// \version 01
///
/// asynchronus communication task
///
/// handles the asynchronous communication
///


///////////////////////////////////////////////////////////////////////////
///
///
/// Delete a message from the busy list
///
/// \param[in] pstBusyEntry 				    pointer to a busy entry
///
/// \param[out] --										--
///
/// \return NU_SUCCESS						Task was created successfully
///       other                 Error
///
///  HISTORY
///
///          DATE                    REMARKS
///
///       13.06.2005		       Created initial version
///
///////////////////////////////////////////////////////////////////////////
static INT32 DeleteMsgFromBusyList ( tBusyEntry *pstBusyEntry )
{
  INT32 iStatus;
  tBusyEntry *pstCurrEntry;

  ///  set the current pointer to the beginning of the list
  pstCurrEntry = stMsgBusyList.head;

  ///  search the entry wich should be deleted
  while ( ( pstCurrEntry != pstBusyEntry ) && ( pstCurrEntry != NU_NULL ) )
  {
    pstCurrEntry = pstCurrEntry->next;
  }

  if ( pstCurrEntry == NU_NULL )
  {
    iStatus = NU_INVALID_ENTRY;
  }
  else
  {
    if ( pstCurrEntry->previous != NU_NULL ) ///  not the first entry
    {
      if ( pstCurrEntry->next != NU_NULL ) ///  not the last entry
      {
        pstCurrEntry->previous->next = pstCurrEntry->next;
        pstCurrEntry->next->previous = pstCurrEntry->previous;
      }
      else ///  the last entry
      {
        stMsgBusyList.tail = pstCurrEntry->previous;
        pstCurrEntry->next->previous = NU_NULL;
      }
    }
    else ///  this is the first entry in the list
    {
      if ( pstCurrEntry->next != NU_NULL ) ///  not the last entry
      {
        stMsgBusyList.head = pstCurrEntry->next;
        pstCurrEntry->next->previous = NU_NULL;
      }
      else
      {
        stMsgBusyList.head = NU_NULL;
        stMsgBusyList.tail = NU_NULL;
      }

    }

    iStatus = NU_Deallocate_Memory ( (void *) pstCurrEntry );
    LOGERR( iStatus, ERR_TRACE, NU_SYS_ERR, 0, 0 );
  }

  return ( iStatus );
}

///////////////////////////////////////////////////////////////////////////
///
///
/// handles ACT busy messages
///
/// \param[in] ulArgc                Number of argumetns passed to the task
///       pvArgv                Pointer to tasks call arguments
///
/// \param[out] --                    --
///
///  RETURN
///
///       --                    This is a never eneding loop. Exits from
///                             this loop take place by means of NUCLEUS
///                             function calls.
///
///  HISTORY
///
///          DATE                    REMARKS
///
///       13.06.2005           Created initial version
///
///////////////////////////////////////////////////////////////////////////
static void ACT_Busy (UINT32 ulArgc, void *pTaskControlBlock)
{
  INT32 iStatus;
  tBusyEntry stReceivedEntry;
  UINT32 uiReceivedSize;

  while (1)
  {
    iStatus = NU_Receive_From_Queue ( &quActBusyQueue, (void *) &stReceivedEntry, USIZE(tBusyEntry), &uiReceivedSize, NU_SUSPEND );
    switch ( iStatus )
    {
      case NU_SUCCESS :
        iStatus = ProcessBusyMessage ((tBusyEntry *) &stReceivedEntry );
      break;

      default :
        LOGERR(iStatus, ERR_TRACE, NU_SYS_ERR, 0, 0);
      break;
    }
  }
}


///////////////////////////////////////////////////////////////////////////
///
///
/// ACT task loop
///
/// \param[in] ulArgc                Number of argumetns passed to the task
///       pvArgv                Pointer to tasks call arguments
///
/// \param[out] --                    --
///
///  RETURN
///
///       --                    This is a never eneding loop. Exits from
///                             this loop take place by means of NUCLEUS
///                             function calls.
///
///  HISTORY
///
///          DATE                    REMARKS
///
///       13.06.2005           Created initial version
///
///////////////////////////////////////////////////////////////////////////
static void ACT_Execution(UINT32 ulArgc, void *pTaskControlBlock)
{
  INT32 iStatus;
  UINT32 uiActSize, uiMsgProcessed;
  tMsgControl stActMsg;

  UNUSED(ulArgc);

  uiMsgProcessed = 0;

  while (uiMsgProcessed == 0)
  {
    ///  Wait for a message
    switch (iStatus = NU_Receive_From_Queue(&quActQueue, (void *) &stActMsg, USIZE(tMsgControl), &uiActSize, NU_SUSPEND))
    {
      case NU_SUCCESS: ///  Message received, process the message
        iStatus = NU_Change_Priority(NU_Current_Task_Pointer(), ACTASK_PRIORITY + 1);

        iStatus = ProcessACTMessage(&stActMsg);
        uiMsgProcessed = 1;
        break;

      default:
        TRACE(TRACE_ALL) ("ACT : Unexpected return 0x%08x\r\n", iStatus);
        break;
    }
  }
  ///  remove the task from system
  ShutDownTask(NU_Current_Task_Pointer(), (T_ShutDownCallBackFnc) DeleteActTask, pTaskControlBlock);
}


///////////////////////////////////////////////////////////////////////////
///
///
/// Process different commandos of ACT
///
/// \param[in] pstActMsg             pointer to ACT message
///
/// \param[out] --                    --
///
/// \return NU_SUCCESS            Task was created successfully
///       other                 Error
///
///  HISTORY
///
///          DATE                    REMARKS
///
///       13.06.2005           Created initial version
///
///////////////////////////////////////////////////////////////////////////
static INT32 ProcessACTMessage(tMsgControl * pstItcMsg)
{
  INT32 iStatus = (INT32) ACT_CMD_ERROR;

  switch (pstItcMsg->stData.iCmd)
  {
    case ACT_CIA_DATA:
      ///  create a new task which handles the communication
      iStatus = ACT_CreateTask(ACT_NORMAL);
      if (NU_SUCCESS == iStatus)
      {
        iStatus = ProcessCiaRequest(pstItcMsg);
        Respond_To_ITC(pstItcMsg, (INT) NU_SUCCESS, NU_SUSPEND);
      }
      else
      {
        ///  at this time it can not be created a new task, so send a busy response
        ///  the maximum number of communication task reached
        Respond_To_ITC(pstItcMsg, (INT) ACT_BUSY_ERROR, NU_SUSPEND);
      }
      break;

    default: ///  command is not supported
      Respond_To_ITC(pstItcMsg, (INT) ACT_CMD_ERROR, NU_SUSPEND);
      break;
  }
  return (iStatus);
}

