import UIKit

class ViewController: UIViewController {
    let drawable: UIView = EAGLView()
    
    var playerBridge: GSBridge?

    override func viewDidLoad() {
        super.viewDidLoad()

        view.addSubview(drawable)
        drawable.translatesAutoresizingMaskIntoConstraints = false
        drawable.leadingAnchor.constraint(equalTo: view.leadingAnchor).isActive = true
        drawable.trailingAnchor.constraint(equalTo: view.trailingAnchor).isActive = true
        drawable.topAnchor.constraint(equalTo: view.safeAreaLayoutGuide.topAnchor).isActive = true
        drawable.bottomAnchor.constraint(equalTo: view.safeAreaLayoutGuide.bottomAnchor).isActive = true
        
        navigationItem.rightBarButtonItems = [
            UIBarButtonItem(title: "Stop", style: .plain, target: self, action: #selector(stop)),
            UIBarButtonItem(title: "Start", style: .plain, target: self, action: #selector(start)),
            UIBarButtonItem(title: "Snapshot", style: .plain, target: self, action: #selector(snapshot)),
        ]
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        
        start()
    }
}

extension ViewController: GSBridgeDelegate {
    func initialized() {
        playerBridge?.play()
    }
    
    @objc private func stop() {
        playerBridge?.stop()
    }
    
    @objc private func start() {
        playerBridge = {
            let bridge: GSBridge = GSBridge("rtsp://str81.creacast.com/grandlilletv/high", view: drawable)
            bridge.delegate = self
            return bridge
        }()
    }
    
    @objc private func snapshot() {
        _ = playerBridge?.takeSnapshot()
    }
}
