# to execute you might need to set the execution policy like:
#set-ExecutionPolicy -ExecutionPolicy Bypass -Scope Process
# for more information see:
#get-help Set-ExecutionPolicy -full
# check status with:
#get-ExecutionPolicy


### set special settings
Set-StrictMode -version 2 #force proper coding (f.e. define variables before using them)
$ErrorActionPreference = 'continue' #stop = no further execution on first error; continue = output error and continue

### store text in variable
$global:strText = "Hnsel"

### define variable with constant values (option readonly is a weaker constant; constant valid throughout the whole session, disable for testing)
### variables used for sending e-mails
set-variable -option constant -name strEMailFrom -value "ME@WORK.de"
set-variable -option constant -name strEMailTo -value "ME@WORK.de"
set-variable -option constant -name strEMailSmtp -value "MAIL.WORK.de"



### must define functions before use; see "help about_function"
function funSendEmailPremature ([string]$inpSubject) {
    $strMailBody = ($global:strText + "`n" + "und" + "`n" + "der Wald").trim.invoke()
    
    Send-MailMessage -subject ("PowerShell - testing Umlauts" + $inpSubject) -from $strEMailFrom -to $strEMailTo -smtpserver $strEMailSmtp -body $strMailBody
}



### start program
funSendEmailPremature ": Hnsel"
echo done