#include <gtk/gtk.h>
#include<stdio.h>

static void
activate (GtkApplication* app,
          gpointer        user_data)
{
  GtkWidget *window;

  window = gtk_application_window_new (app);
  gtk_window_set_title (GTK_WINDOW (window), "Window");
  gtk_window_set_default_size (GTK_WINDOW (window), 400, 200);
  gtk_widget_show_all (window);

  GtkWidget *toolbar = gtk_toolbar_new ();
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_icon_size (GTK_TOOLBAR (toolbar),GTK_ICON_SIZE_LARGE_TOOLBAR);
  gtk_container_add (GTK_CONTAINER (window), toolbar);
  gtk_widget_show (toolbar);

  /* add the location bar tool item */
  GtkWidget *tool_item = gtk_tool_item_new ();
  gtk_tool_item_set_expand (tool_item, TRUE);
  gtk_toolbar_insert (GTK_TOOLBAR (toolbar), GTK_TOOL_ITEM(tool_item), -1);
  gtk_widget_show (GTK_WIDGET (tool_item));

  /* add some label */
  GtkWidget * myLabel = gtk_label_new ("some Random Label Which Has min Width More Than 7");
  gtk_container_add (GTK_CONTAINER (tool_item), myLabel);
  gtk_widget_show (myLabel);

  gint min, natural;
  gtk_widget_get_preferred_width(toolbar,&min,&natural);
  printf("toolbar min: %i toolbar natural: %i\n", min, natural);
}

int
main (int    argc,
      char **argv)
{
  GtkApplication *app;
  int status;

  app = gtk_application_new ("org.gtk.example", G_APPLICATION_FLAGS_NONE);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);
  status = g_application_run (G_APPLICATION (app), argc, argv);
  g_object_unref (app);
  return status;
}
