#include <string.h>
#include "gsth264testmeta.h"


static gboolean
gst_h264_test_meta_init (GstMeta * meta, gpointer params, GstBuffer * buffer)
{
    GstH264TestMeta *h264_test_meta = (GstH264TestMeta *) meta;
    h264_test_meta->length = 0;
    h264_test_meta->payload = NULL;
    
    return TRUE;
}

static gboolean
gst_h264_test_meta_transform (GstBuffer * transbuf, GstMeta * meta,
                    GstBuffer * buffer, GQuark type, gpointer data)
{
     GstH264TestMeta *h264_test_meta = (GstH264TestMeta *) meta;
     
     if (GST_META_TRANSFORM_IS_COPY (type)) 
     {
         GstMetaTransformCopy *copy = data;
         
         if (!copy->region) 
         {
             //if(!gst_buffer_is_writable(transbuf))
             //{
             //    gst_buffer_make_writable(transbuf);
             //}
            g_print("%s len: %d str:%s \n", __func__, h264_test_meta->length, h264_test_meta->payload);
            gst_buffer_add_h264_test_meta (transbuf, h264_test_meta->length, h264_test_meta->payload);
         }
     }
     return TRUE;
}

static void
gst_h264_test_meta_free (GstMeta * meta, GstBuffer * buffer)
{
    GstH264TestMeta *h264_test_meta = (GstH264TestMeta *) meta;
    if(h264_test_meta->payload)
    {
        g_free(h264_test_meta->payload);
    }
    
    h264_test_meta->length = 0;
    h264_test_meta->payload = NULL;
}


GType
gst_h264_test_meta_api_get_type (void)
{
    static volatile GType type = 0;
    static const gchar *tags[] = {"video", NULL};
    
    if(g_once_init_enter(&type))
    {
        GType _type = gst_meta_api_type_register("GstH264TestMetaApi", tags);
        g_once_init_leave(&type, _type);
    }
  
  return type;
}

const GstMetaInfo *
gst_h264_test_meta_get_info (void)
{
	static const GstMetaInfo *h264_test_meta_info = NULL;
    
    if (g_once_init_enter (&h264_test_meta_info))
    {
        const GstMetaInfo *mi = gst_meta_register (GST_H264_TEST_META_API_TYPE,
        "GstH264TestMeta",
        sizeof (GstH264TestMeta),
        (GstMetaInitFunction) gst_h264_test_meta_init,
        (GstMetaFreeFunction) gst_h264_test_meta_free,
        (GstMetaTransformFunction) gst_h264_test_meta_transform);
        g_once_init_leave (&h264_test_meta_info, mi);
    }
    
	return h264_test_meta_info;
}

GstH264TestMeta * 
gst_buffer_add_h264_test_meta (GstBuffer *buffer, gint length, const gpointer *payload)
{
    GstH264TestMeta *h264_test_meta;
  
    g_return_val_if_fail (GST_IS_BUFFER (buffer), NULL);
    
    h264_test_meta = (GstH264TestMeta *) gst_buffer_add_meta (buffer,
                                        GST_H264_TEST_META_INFO, NULL);
    
    h264_test_meta->length = length;
    h264_test_meta->payload = g_new0(gchar, length);
    if(h264_test_meta->payload)
    {

        memcpy(h264_test_meta->payload, payload, length);
 
    }
    
    return h264_test_meta;
}

GstH264TestMeta * 
gst_buffer_get_h264_test_meta (GstBuffer *buffer)
{
    GstH264TestMeta *h264_test_meta;
    h264_test_meta = (GstH264TestMeta *)gst_buffer_get_meta(buffer, GST_H264_TEST_META_API_TYPE);
    
    return h264_test_meta;
}

const gchar * const *
gst_buffer_get_h264_test_get_tags(void )
{
    return gst_meta_api_type_get_tags (GST_H264_TEST_META_API_TYPE);
}
 