#!/usr/bin/python

import os
os.environ['GI_TYPELIB_PATH'] = '/usr/local/lib/girepository-1.0/'

import sys, subprocess, gi
gi.require_version('Gst', '1.0')
from gi.repository import GObject, Gst, GstRtspServer, GstRtsp, GLib

Gst.init(sys.argv)
factory = GstRtspServer.RTSPMediaFactory()
factory.set_launch('videotestsrc ! x264enc ! rtph264pay name=pay0')
factory.set_shared(True)

server = GstRtspServer.RTSPServer.new()
server.set_service("8554")
server.get_mount_points().add_factory('/stream', factory)
server.attach()

# allow ctrl-c exit
import signal
signal.signal(signal.SIGINT, signal.SIG_DFL)

GLib.MainLoop.new(None, False).run()
