/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.webp;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.plantuml.webp.VP8Decoder;

public class Portrait {
    private final String name;
    private final int age;
    private final byte[] webp;

    public Portrait(String name, int age, byte[] webp) throws IOException {
        this.name = name;
        this.age = age;
        this.webp = webp;
    }

    public BufferedImage getBufferedImage() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.webp);
            ImageInputStream iis = ImageIO.createImageInputStream(is);
            VP8Decoder vp8Decoder = new VP8Decoder();
            vp8Decoder.decodeFrame(iis, false);
            iis.close();
            return vp8Decoder.getFrame().getBufferedImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getAge() {
        return this.age;
    }
}

