/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final HtmlColor specificBackColor;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;

    public EntityImageEmptyPackage(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.skinParam = skinParam;
        this.specificBackColor = entity.getColors(skinParam).getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.desc.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dim, 20.0, 20.0 + dim.getHeight() * 2.0);
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.packageBorder, this.getStereo());
        if (stroke == null) {
            stroke = new UStroke(2.0);
        }
        return stroke;
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        HtmlColor back = Cluster.getBackColor(this.specificBackColor, this.skinParam, this.stereotype);
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().getPackageStyle(), null, this.desc, TextBlockUtils.empty(0.0, 0.0), 0.0, 0.0, widthTotal, heightTotal, this.getStroke());
        decoration.drawU(ug, back, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.packageBorder, this.getStereo()), this.getSkinParam().shadowing());
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

