/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolComponent2
extends USymbol {
    USymbolComponent2() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.COMPONENT2;
    }

    private void drawNode(UGraphic ug, double widthTotal, double heightTotal, boolean shadowing) {
        URectangle form = new URectangle(widthTotal, heightTotal);
        if (shadowing) {
            form.setDeltaShadow(4.0);
        }
        URectangle small = new URectangle(15.0, 10.0);
        URectangle tiny = new URectangle(4.0, 2.0);
        ug.draw(form);
        ug.apply(new UTranslate(widthTotal - 20.0, 5.0)).draw(small);
        ug.apply(new UTranslate(widthTotal - 22.0, 7.0)).draw(tiny);
        ug.apply(new UTranslate(widthTotal - 22.0, 11.0)).draw(tiny);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 25.0, 20.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolComponent2.this.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolComponent2.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolComponent2.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolComponent2.this.drawNode(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                title.drawU(ug.apply(new UTranslate(3.0, 13.0)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }
}

