/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockBordered;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.webp.Portrait;
import net.sourceforge.plantuml.webp.Portraits;

public class DateEventUtils {
    public static TextBlock addEvent(TextBlock textBlock, HtmlColor color) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd");
        String today = dateFormat.format(new Date());
        if ("11-05".equals(today)) {
            List<String> asList = Arrays.asList("<u>November 5th, 1955", "Doc Brown's discovery of the Flux Capacitor, that makes time-travel possible.");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
        }
        if ("08-29".equals(today)) {
            List<String> asList = Arrays.asList("<u>August 29th, 1997", "Skynet becomes self-aware at 02:14 AM Eastern Time.");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
        }
        if ("06-29".equals(today)) {
            List<String> asList = Arrays.asList("<u>June 29th, 1975", "\"It was the first time in history that anyone had typed", "a character on a keyboard and seen it show up on their", "own computer's screen right in front of them.\"", "\t\t\t\t\t\t\t\t\t\t<i>Steve Wozniak");
            return TextBlockUtils.mergeTB(textBlock, DateEventUtils.getComment(asList, color), HorizontalAlignment.LEFT);
        }
        if ("01-07".equals(today) || "01-08".equals(today)) {
            return DateEventUtils.addCharlie(textBlock);
        }
        return textBlock;
    }

    private static TextBlock addMemorial(TextBlock textBlock, HtmlColor color) {
        Portrait portrait = new Portraits().getOne();
        if (portrait == null) {
            return textBlock;
        }
        final BufferedImage im = portrait.getBufferedImage();
        if (im == null) {
            return textBlock;
        }
        List<String> asList = Arrays.asList("A thought for those who died in Paris the 13th November 2015.");
        String name = portrait.getName();
        UFont font = new UFont("SansSerif", 1, 12);
        TextBlock comment = Display.create(name).create(new FontConfiguration(font, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        comment = TextBlockUtils.withMargin(comment, 4.0, 4.0);
        TextBlock bottom0 = DateEventUtils.getComment(asList, color);
        AbstractTextBlock bottom1 = new AbstractTextBlock(){
            private double margin = 10.0;

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(new UTranslate(0.0, this.margin));
                ug.draw(new UImage(im));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(im.getWidth(), this.margin + (double)im.getHeight());
            }
        };
        TextBlock bottom = TextBlockUtils.mergeTB(bottom0, TextBlockUtils.mergeLR(bottom1, comment, VerticalAlignment.CENTER), HorizontalAlignment.LEFT);
        return TextBlockUtils.mergeTB(textBlock, bottom, HorizontalAlignment.LEFT);
    }

    private static TextBlock addCharlie(TextBlock textBlock) {
        AbstractTextBlock charlie = new AbstractTextBlock(){
            private final BufferedImage charlie = PSystemVersion.getCharlieImage();

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(new UImage(this.charlie));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(this.charlie.getWidth(), this.charlie.getHeight());
            }
        };
        return TextBlockUtils.mergeTB(charlie, textBlock, HorizontalAlignment.LEFT);
    }

    private static TextBlock getComment(List<String> asList, HtmlColor color) {
        UFont font = new UFont("SansSerif", 1, 14);
        TextBlock comment = Display.create(asList).create(new FontConfiguration(font, color, HtmlColorUtils.BLUE, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        comment = TextBlockUtils.withMargin(comment, 4.0, 4.0);
        comment = new TextBlockBordered(comment, color);
        comment = TextBlockUtils.withMargin(comment, 10.0, 10.0);
        return comment;
    }
}

