/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class FtileIfLongHorizontal
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Ftile tile2;
    private final List<Ftile> diamonds;
    private final List<Ftile> couples = new ArrayList<Ftile>();
    private final HtmlColor arrowColor;

    private FtileIfLongHorizontal(List<Ftile> diamonds, List<Ftile> tiles, Ftile tile2, HtmlColor arrowColor) {
        super(tiles.get(0).shadowing() || tile2.shadowing());
        if (diamonds.size() != tiles.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < diamonds.size(); ++i) {
            this.couples.add(new FtileAssemblySimple(diamonds.get(i), tiles.get(i)));
        }
        this.tile2 = tile2;
        this.diamonds = new ArrayList<Ftile>(diamonds);
        this.tiles = new ArrayList<Ftile>(tiles);
        this.arrowColor = arrowColor;
    }

    private static List<Ftile> alignDiamonds(List<Ftile> diamonds, StringBounder stringBounder) {
        double maxOutY = 0.0;
        for (Ftile diamond : diamonds) {
            maxOutY = Math.max(maxOutY, diamond.calculateDimension(stringBounder).getOutY());
        }
        ArrayList<Ftile> result = new ArrayList<Ftile>();
        for (int i = 0; i < diamonds.size(); ++i) {
            Ftile diamond = diamonds.get(i);
            double missing = maxOutY - diamond.calculateDimension(stringBounder).getOutY();
            assert (missing >= 0.0);
            diamond = FtileUtils.addVerticalMargin(diamond, missing / 2.0, 20.0);
            result.add(diamond);
        }
        return result;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        for (Ftile tile : this.couples) {
            result.addAll(tile.getSwimlanes());
        }
        result.addAll(this.tile2.getSwimlanes());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.couples.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor borderColor, HtmlColor backColor, HtmlColor arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> thens, Branch branch2, FontConfiguration fc, LinkRendering topInlinkRendering, LinkRendering afterEndwhile) {
        ArrayList<Ftile> tiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            tiles.add(new FtileMinWidth(branch.getFtile(), 30.0));
        }
        FtileMinWidth tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        List<Ftile> diamonds = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            TextBlock tb1 = branch.getLabelPositive().create(fc, HorizontalAlignment.LEFT, ftileFactory);
            TextBlock tbTest = branch.getLabelTest().create(fc, HorizontalAlignment.LEFT, ftileFactory);
            FtileDiamondInside2 diamond = new FtileDiamondInside2(branch.shadowing(), backColor, borderColor, swimlane, tbTest);
            diamond = diamond.withNorth(tb1);
            diamonds.add(diamond);
        }
        TextBlock tb2 = branch2.getLabelPositive().create(fc, HorizontalAlignment.LEFT, ftileFactory);
        int last = diamonds.size() - 1;
        diamonds.set(last, ((FtileDiamondInside2)diamonds.get(last)).withEast(tb2));
        diamonds = FtileIfLongHorizontal.alignDiamonds(diamonds, ftileFactory.getStringBounder());
        FtileIfLongHorizontal result = new FtileIfLongHorizontal(diamonds, tiles, tile2, arrowColor);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (int i = 0; i < thens.size(); ++i) {
            Ftile ftile = (Ftile)tiles.get(i);
            Ftile diam = diamonds.get(i);
            HtmlColor color = FtileIfWithLinks.getInColor(thens.get(i), arrowColor);
            FtileIfLongHorizontal ftileIfLongHorizontal = result;
            ftileIfLongHorizontal.getClass();
            conns.add(ftileIfLongHorizontal.new ConnectionVerticalIn(diam, ftile, color == null ? arrowColor : color));
            FtileIfLongHorizontal ftileIfLongHorizontal2 = result;
            ftileIfLongHorizontal2.getClass();
            conns.add(ftileIfLongHorizontal2.new ConnectionVerticalOut(ftile, arrowColor));
        }
        HtmlColor topInColor = LinkRendering.getColor(topInlinkRendering, arrowColor);
        for (int i = 0; i < diamonds.size() - 1; ++i) {
            Ftile diam1 = diamonds.get(i);
            Ftile diam2 = diamonds.get(i + 1);
            FtileIfLongHorizontal ftileIfLongHorizontal = result;
            ftileIfLongHorizontal.getClass();
            conns.add(ftileIfLongHorizontal.new ConnectionHorizontal(diam1, diam2, topInColor));
        }
        FtileIfLongHorizontal ftileIfLongHorizontal = result;
        ftileIfLongHorizontal.getClass();
        conns.add(ftileIfLongHorizontal.new ConnectionIn(topInColor));
        FtileIfLongHorizontal ftileIfLongHorizontal3 = result;
        ftileIfLongHorizontal3.getClass();
        conns.add(ftileIfLongHorizontal3.new ConnectionLastElseIn(FtileIfWithLinks.getInColor(branch2, arrowColor)));
        FtileIfLongHorizontal ftileIfLongHorizontal4 = result;
        ftileIfLongHorizontal4.getClass();
        conns.add(ftileIfLongHorizontal4.new ConnectionLastElseOut(arrowColor));
        HtmlColor horizontalOutColor = LinkRendering.getColor(afterEndwhile, arrowColor);
        FtileIfLongHorizontal ftileIfLongHorizontal5 = result;
        ftileIfLongHorizontal5.getClass();
        conns.add(ftileIfLongHorizontal5.new ConnectionHline(horizontalOutColor));
        return FtileUtils.addConnection((Ftile)result, conns);
    }

    private static double getYdiamontOutToLeft(FtileGeometry dimDiamond1, StringBounder stringBounder) {
        return (dimDiamond1.getInY() + dimDiamond1.getOutY()) / 2.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (child == this.tile2) {
            return this.getTranslate2(stringBounder);
        }
        if (this.couples.contains(child)) {
            return this.getTranslateCouple1(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dim2 = this.tile2.calculateDimension(stringBounder);
        double x2 = ((Dimension2D)dimTotal).getWidth() - ((Dimension2D)dim2).getWidth();
        double h = 0.0;
        double y2 = (((Dimension2D)dimTotal).getHeight() - 0.0 - ((Dimension2D)dim2).getHeight()) / 2.0 + 0.0;
        return new UTranslate(x2, y2);
    }

    private UTranslate getTranslateDiamond1(Ftile diamond, StringBounder stringBounder) {
        int idx = this.diamonds.indexOf(diamond);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate trCouple = this.getTranslateCouple1(this.couples.get(idx), stringBounder);
        UTranslate in = this.couples.get(idx).getTranslateFor(diamond, stringBounder);
        return trCouple.compose(in);
    }

    public UTranslate getTranslate1(Ftile tile, StringBounder stringBounder) {
        int idx = this.tiles.indexOf(tile);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        UTranslate trCouple = this.getTranslateCouple1(this.couples.get(idx), stringBounder);
        UTranslate in = this.couples.get(idx).getTranslateFor(tile, stringBounder);
        return trCouple.compose(in);
    }

    private UTranslate getTranslateCouple1(Ftile candidat, StringBounder stringBounder) {
        double x1 = 0.0;
        for (Ftile couple : this.couples) {
            FtileGeometry dim1 = couple.calculateDimension(stringBounder);
            if (couple == candidat) {
                return new UTranslate(x1, 25.0);
            }
            x1 += dim1.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile couple : this.couples) {
            ug.apply(this.getTranslateCouple1(couple, stringBounder)).draw(couple);
        }
        ug.apply(this.getTranslate2(stringBounder)).draw(this.tile2);
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D result = new Dimension2DDouble(0.0, 0.0);
        for (Ftile couple : this.couples) {
            result = Dimension2DDouble.mergeLR(result, couple.calculateDimension(stringBounder));
        }
        FtileGeometry dimTile2 = this.tile2.calculateDimension(stringBounder);
        result = Dimension2DDouble.mergeLR(result, dimTile2);
        result = Dimension2DDouble.delta(result, 20.0 * (double)this.couples.size(), 100.0);
        return new FtileGeometry(result, result.getWidth() / 2.0, 0.0);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> all = new ArrayList<Ftile>(this.tiles);
        all.add(this.tile2);
        for (Ftile tmp : all) {
            if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimTotal, ((Dimension2D)dimTotal).getWidth() / 2.0, 0.0, ((Dimension2D)dimTotal).getHeight());
        }
        return new FtileGeometry(dimTotal, ((Dimension2D)dimTotal).getWidth() / 2.0, 0.0);
    }

    class ConnectionHline
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionHline(HtmlColor arrowColor) {
            super(null, null);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            FtileGeometry totalDim = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder);
            ArrayList<Ftile> all = new ArrayList<Ftile>(FtileIfLongHorizontal.this.couples);
            all.add(FtileIfLongHorizontal.this.tile2);
            double minX = ((Dimension2D)totalDim).getWidth() / 2.0;
            double maxX = ((Dimension2D)totalDim).getWidth() / 2.0;
            for (Ftile tmp : all) {
                if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
                UTranslate ut = FtileIfLongHorizontal.this.getTranslateFor(tmp, stringBounder);
                double out = tmp.calculateDimension(stringBounder).translate(ut).getLeft();
                minX = Math.min(minX, out);
                maxX = Math.max(maxX, out);
            }
            Snake s = new Snake(this.arrowColor);
            s.goUnmergeable();
            double height = ((Dimension2D)totalDim).getHeight();
            s.addPoint(minX, height);
            s.addPoint(maxX, height);
            ug.draw(s);
        }
    }

    class ConnectionVerticalOut
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalOut(Ftile tile, HtmlColor color) {
            super(tile, null);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            double totalHeight = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D p1 = this.getP1(stringBounder);
            if (p1 == null) {
                return;
            }
            Point2D.Double p2 = new Point2D.Double(p1.getX(), totalHeight);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry geo = this.getFtile1().calculateDimension(stringBounder);
            if (!geo.hasPointOut()) {
                return null;
            }
            Point2D p = geo.getPointOut();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionVerticalIn
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionVerticalIn(Ftile diamond, Ftile tile, HtmlColor color) {
            super(diamond, tile);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            Point2D p = this.getFtile1().calculateDimension(stringBounder).getPointOut();
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D p = this.getFtile2().calculateDimension(stringBounder).getPointIn();
            return FtileIfLongHorizontal.this.getTranslate1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionLastElseOut
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseOut(HtmlColor arrowColor) {
            super(FtileIfLongHorizontal.this.tile2, null);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            UTranslate tr1 = FtileIfLongHorizontal.this.getTranslate2(stringBounder);
            FtileGeometry dim = this.getFtile1().calculateDimension(stringBounder);
            if (!dim.hasPointOut()) {
                return;
            }
            Point2D p1 = tr1.getTranslated(dim.getPointOut());
            double totalHeight = FtileIfLongHorizontal.this.calculateDimensionInternal(stringBounder).getHeight();
            Point2D.Double p2 = new Point2D.Double(p1.getX(), totalHeight);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionLastElseIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionLastElseIn(HtmlColor arrowColor) {
            super((Ftile)FtileIfLongHorizontal.this.diamonds.get(FtileIfLongHorizontal.this.diamonds.size() - 1), FtileIfLongHorizontal.this.tile2);
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            Point2D p1 = this.getP1(ug.getStringBounder());
            UTranslate tr2 = FtileIfLongHorizontal.this.getTranslate2(ug.getStringBounder());
            Point2D p2 = tr2.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(dimDiamond1.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor arrowColor) {
            super(null, (Ftile)FtileIfLongHorizontal.this.diamonds.get(0));
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            UTranslate tr = FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), ug.getStringBounder());
            Point2D p2 = tr.getTranslated(this.getFtile2().calculateDimension(ug.getStringBounder()).getPointIn());
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D p1 = FtileIfLongHorizontal.this.calculateDimensionInternal(ug.getStringBounder()).getPointIn();
            snake.addPoint(p1);
            snake.addPoint(p2.getX(), p1.getY());
            snake.addPoint(p2);
            ug.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final HtmlColor color;

        public ConnectionHorizontal(Ftile diam1, Ftile diam2, HtmlColor color) {
            super(diam1, diam2);
            this.color = color;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.color, Arrows.asToRight());
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(dimDiamond1.getLeft() * 2.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile1(), stringBounder).getTranslated(p);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry dimDiamond1 = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double p = new Point2D.Double(0.0, FtileIfLongHorizontal.getYdiamontOutToLeft(dimDiamond1, stringBounder));
            return FtileIfLongHorizontal.this.getTranslateDiamond1(this.getFtile2(), stringBounder).getTranslated(p);
        }
    }
}

