/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileGroup;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.SourceFileReader2;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.ftp.FtpServer;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagramFactory;
import net.sourceforge.plantuml.png.MetadataTag;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.ugraphic.SpriteGrayLevel;
import net.sourceforge.plantuml.ugraphic.SpriteUtils;
import net.sourceforge.plantuml.version.Version;

public class Run {
    public static void main(String[] argsArray) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        Option option = new Option(argsArray);
        if (OptionFlags.getInstance().isEncodesprite()) {
            Run.encodeSprite(option.getResult());
            return;
        }
        if (OptionFlags.getInstance().isVerbose()) {
            Log.info("PlantUML Version " + Version.versionString());
            Log.info("GraphicsEnvironment.isHeadless() " + GraphicsEnvironment.isHeadless());
        }
        if (GraphicsEnvironment.isHeadless()) {
            Log.info("Forcing -Djava.awt.headless=true");
            System.setProperty("java.awt.headless", "true");
            Log.info("java.awt.headless set as true");
        }
        if (OptionFlags.getInstance().isPrintFonts()) {
            Run.printFonts();
            return;
        }
        if (option.getFtpPort() != -1) {
            Run.goFtp(option);
            return;
        }
        boolean error = false;
        boolean forceQuit = false;
        if (option.isPattern()) {
            Run.managePattern();
        } else if (OptionFlags.getInstance().isGui()) {
            File f;
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception e) {
                // empty catch block
            }
            List<String> list = option.getResult();
            File dir = null;
            if (list.size() == 1 && (f = new File(list.get(0))).exists() && f.isDirectory()) {
                dir = f;
            }
            new MainWindow2(option, dir);
        } else if (option.isPipe() || option.isSyntax()) {
            Run.managePipe(option);
            forceQuit = true;
        } else if (option.isFailfast2()) {
            long start2 = System.currentTimeMillis();
            option.setCheckOnly(true);
            error = Run.manageAllFiles(option);
            option.setCheckOnly(false);
            if (option.isDuration()) {
                double duration = (double)(System.currentTimeMillis() - start2) / 1000.0;
                Log.error("Check Duration = " + duration + " seconds");
            }
            if (!error) {
                error = Run.manageAllFiles(option);
            }
            forceQuit = true;
        } else {
            error = Run.manageAllFiles(option);
            forceQuit = true;
        }
        if (option.isDuration()) {
            double duration = (double)(System.currentTimeMillis() - start) / 1000.0;
            Log.error("Duration = " + duration + " seconds");
        }
        if (error) {
            Log.error("Some diagram description contains errors");
            System.exit(1);
        }
        if (forceQuit && OptionFlags.getInstance().isSystemExit()) {
            System.exit(0);
        }
    }

    private static void encodeSprite(List<String> result) throws IOException {
        File f;
        SpriteGrayLevel level = SpriteGrayLevel.GRAY_16;
        boolean compressed = false;
        if (result.size() > 1 && result.get(0).matches("(4|8|16)z?")) {
            if (result.get(0).startsWith("8")) {
                level = SpriteGrayLevel.GRAY_8;
            }
            if (result.get(0).startsWith("4")) {
                level = SpriteGrayLevel.GRAY_4;
            }
            compressed = StringUtils.goLowerCase(result.get(0)).endsWith("z");
            f = new File(result.get(1));
        } else {
            f = new File(result.get(0));
        }
        BufferedImage im = ImageIO.read(f);
        String name = Run.getSpriteName(f);
        String s = compressed ? SpriteUtils.encodeCompressed(im, name, level) : SpriteUtils.encode(im, name, level);
        System.out.println(s);
    }

    private static String getSpriteName(File f) {
        String s = Run.getSpriteNameInternal(f);
        if (s.length() == 0) {
            return "test";
        }
        return s;
    }

    private static String getSpriteNameInternal(File f) {
        StringBuilder sb = new StringBuilder();
        for (char c : f.getName().toCharArray()) {
            if (!("" + c).matches("[\\p{L}0-9_]")) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void goFtp(Option option) throws IOException {
        int ftpPort = option.getFtpPort();
        System.err.println("ftpPort=" + ftpPort);
        FtpServer ftpServer = new FtpServer(ftpPort, option.getFileFormat());
        ftpServer.go();
    }

    public static void printFonts() {
        String[] name;
        Font[] fonts;
        for (Font f : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            System.out.println("f=" + f + "/" + f.getPSName() + "/" + f.getName() + "/" + f.getFontName() + "/" + f.getFamily());
        }
        for (String n : name = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            System.out.println("n=" + n);
        }
    }

    private static void managePattern() {
        Run.printPattern(new SequenceDiagramFactory());
        Run.printPattern(new ClassDiagramFactory());
        Run.printPattern(new ActivityDiagramFactory());
        Run.printPattern(new DescriptionDiagramFactory());
        Run.printPattern(new StateDiagramFactory());
        Run.printPattern(new ObjectDiagramFactory());
    }

    private static void printPattern(UmlDiagramFactory factory) {
        System.out.println();
        System.out.println(factory.getClass().getSimpleName().replaceAll("Factory", ""));
        List<String> descriptions = factory.getDescription();
        for (String s : descriptions) {
            System.out.println(s);
        }
    }

    private static void managePipe(Option option) throws IOException {
        String charset = option.getCharset();
        BufferedReader br = charset == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, charset));
        Run.managePipe(option, br, System.out);
    }

    public static void managePipe(Option option, BufferedReader br, PrintStream ps) throws IOException {
        StringBuilder sb = new StringBuilder();
        String s = null;
        while ((s = br.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        String source = sb.toString();
        if (!source.contains("@startuml")) {
            source = "@startuml\n" + source + "\n@enduml";
        }
        SourceStringReader sourceStringReader = new SourceStringReader(new Defines(), source, option.getConfig());
        if (option.isSyntax()) {
            Diagram system = sourceStringReader.getBlocks().get(0).getDiagram();
            if (system instanceof UmlDiagram) {
                ps.println(((UmlDiagram)system).getUmlDiagramType().name());
                ps.println(system.getDescription());
            } else if (system instanceof PSystemError) {
                ps.println("ERROR");
                PSystemError sys = (PSystemError)system;
                ps.println(sys.getHigherErrorPosition());
                for (ErrorUml er : sys.getErrorsUml()) {
                    ps.println(er.getError());
                }
            } else {
                ps.println("OTHER");
                ps.println(system.getDescription());
            }
        } else if (option.isPipe()) {
            sourceStringReader.generateImage(ps, 0, option.getFileFormatOption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean manageAllFiles(Option option) throws IOException, InterruptedException {
        File lockFile = null;
        try {
            if (OptionFlags.getInstance().isWord()) {
                File dir = new File(option.getResult().get(0));
                File javaIsRunningFile = new File(dir, "javaisrunning.tmp");
                javaIsRunningFile.delete();
                lockFile = new File(dir, "javaumllock.tmp");
            }
            boolean bl = Run.processArgs(option);
            return bl;
        }
        finally {
            if (lockFile != null) {
                lockFile.delete();
            }
        }
    }

    private static boolean processArgs(Option option) throws IOException, InterruptedException {
        if (!(option.isDecodeurl() || option.getNbThreads() <= 0 || option.isCheckOnly() || OptionFlags.getInstance().isMetadata())) {
            return Run.multithread(option);
        }
        boolean errorGlobal = false;
        for (String s : option.getResult()) {
            if (option.isDecodeurl()) {
                Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
                System.out.println("@startuml");
                System.out.println(transcoder.decode(s));
                System.out.println("@enduml");
                continue;
            }
            FileGroup group = new FileGroup(s, option.getExcludes(), option);
            for (File f : group.getFiles()) {
                try {
                    boolean error = Run.manageFileInternal(f, option);
                    if (error) {
                        errorGlobal = true;
                    }
                    if (!error || !option.isFailfastOrFailfast2()) continue;
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return errorGlobal;
    }

    private static boolean multithread(final Option option) throws InterruptedException {
        Log.info("Using several threads: " + option.getNbThreads());
        ExecutorService executor = Executors.newFixedThreadPool(option.getNbThreads());
        final AtomicBoolean errors = new AtomicBoolean(false);
        for (String s : option.getResult()) {
            FileGroup group = new FileGroup(s, option.getExcludes(), option);
            for (final File f : group.getFiles()) {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (errors.get() && option.isFailfastOrFailfast2()) {
                            return;
                        }
                        try {
                            boolean error = Run.manageFileInternal(f, option);
                            if (error) {
                                errors.set(true);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        return errors.get();
    }

    private static boolean manageFileInternal(File f, Option option) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isMetadata()) {
            System.out.println("------------------------");
            System.out.println(f);
            System.out.println();
            System.out.println(new MetadataTag(f, "plantuml").getData());
            System.out.println("------------------------");
            return false;
        }
        ISourceFileReader sourceFileReader = option.getOutputFile() == null ? new SourceFileReader(option.getDefaultDefines(), f, option.getOutputDir(), option.getConfig(), option.getCharset(), option.getFileFormatOption()) : new SourceFileReader2(option.getDefaultDefines(), f, option.getOutputFile(), option.getConfig(), option.getCharset(), option.getFileFormatOption());
        if (option.isComputeurl()) {
            List<String> urls = sourceFileReader.getEncodedUrl();
            for (String s : urls) {
                System.out.println(s);
            }
            return false;
        }
        if (option.isCheckOnly()) {
            boolean hasError = sourceFileReader.hasError();
            List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
            Run.hasErrors(f, result);
            return hasError;
        }
        List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
        return Run.hasErrors(f, result);
    }

    private static boolean hasErrors(File f, List<GeneratedImage> list) throws IOException {
        boolean result = false;
        for (GeneratedImage i : list) {
            int lineError = i.lineErrorRaw();
            if (lineError == -1) continue;
            Log.error("Error line " + lineError + " in file: " + f.getCanonicalPath());
            result = true;
        }
        return result;
    }
}

