/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.StringUtils;

public enum FileFormat {
    PNG,
    SVG,
    EPS,
    EPS_TEXT,
    ATXT,
    UTXT,
    XMI_STANDARD,
    XMI_STAR,
    XMI_ARGO,
    PDF,
    MJPEG,
    ANIMATED_GIF,
    HTML,
    HTML5,
    VDX,
    LATEX,
    BASE64;


    public String getFileSuffix() {
        if (this.name().startsWith("XMI")) {
            return ".xmi";
        }
        if (this == MJPEG) {
            return ".avi";
        }
        if (this == ANIMATED_GIF) {
            return ".gif";
        }
        if (this == EPS_TEXT) {
            return EPS.getFileSuffix();
        }
        return "." + StringUtils.goLowerCase(this.name());
    }

    public boolean isEps() {
        if (this == EPS) {
            return true;
        }
        return this == EPS_TEXT;
    }

    public String changeName(String fileName, int cpt) {
        if (cpt == 0) {
            return this.changeName(fileName, this.getFileSuffix());
        }
        return this.changeName(fileName, "_" + String.format("%03d", cpt) + this.getFileSuffix());
    }

    private String changeName(String fileName, String replacement) {
        String result = fileName.replaceAll("\\.\\w+$", replacement);
        if (result.equals(fileName)) {
            result = fileName + replacement;
        }
        return result;
    }

    public File computeFilename(File pngFile, int i) {
        if (i == 0) {
            return pngFile;
        }
        File dir = pngFile.getParentFile();
        return new File(dir, this.computeFilename(pngFile.getName(), i));
    }

    public String computeFilename(String name, int i) {
        if (i == 0) {
            return name;
        }
        return name.replaceAll("\\" + this.getFileSuffix() + "$", "_" + String.format("%03d", i) + this.getFileSuffix());
    }
}

