/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth;

import com.ctreber.acearth.ConfigurationACearth;
import com.ctreber.acearth.MapDataReader;
import com.ctreber.acearth.gui.CanvasACearth;
import com.ctreber.acearth.plugins.Plugin;
import com.ctreber.acearth.plugins.markers.Marker;
import com.ctreber.acearth.plugins.markers.PluginMarkers;
import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.projection.ProjectionCyl;
import com.ctreber.acearth.projection.ProjectionMerc;
import com.ctreber.acearth.projection.ProjectionOrtho;
import com.ctreber.acearth.renderer.Renderer;
import com.ctreber.acearth.renderer.RowTypeRendererScanBit;
import com.ctreber.acearth.renderer.RowTypeRendererScanDot;
import com.ctreber.acearth.scanbit.BitGeneratorMap;
import com.ctreber.acearth.scanbit.BitGeneratorMapDefault;
import com.ctreber.acearth.scanbit.BitGeneratorMapOrtho;
import com.ctreber.acearth.scandot.DotGeneratorLines;
import com.ctreber.acearth.scandot.DotGeneratorStars;
import com.ctreber.acearth.scandot.ScanDot;
import com.ctreber.acearth.scandot.ScanDotGenerator;
import com.ctreber.acearth.shader.Shader;
import com.ctreber.acearth.shader.ShaderDefault;
import com.ctreber.acearth.shader.ShaderFlat;
import com.ctreber.acearth.shader.ShaderOrtho;
import com.ctreber.acearth.util.Coordinate;
import com.ctreber.acearth.util.SunPositionCalculator;
import com.ctreber.acearth.util.Toolkit;
import com.ctreber.aclib.sort.QuickSort;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ACearth {
    public static final String VERSION = "1.1";
    public static final String BUILD = "22.11.2002 004";
    private ConfigurationACearth fConf = new ConfigurationACearth();
    private long fCurrentTime;
    private CanvasACearth fCanvas;
    private Coordinate fViewPos;
    private double fViewRotation;
    private List fPlugins = new ArrayList();

    public ACearth(List<Marker> markers) {
        this.fPlugins.add(new PluginMarkers(markers));
    }

    public void exportPng(OutputStream os) throws IOException {
        this.fCanvas = new CanvasACearth(this, this.fConf.getInt("imageWidth"), this.fConf.getInt("imageHeight"));
        this.update();
        this.fCanvas.saveToImage(os);
    }

    public void update() throws IOException {
        ScanDotGenerator lGenerator;
        Projection lProjection = null;
        Shader lShader = null;
        BitGeneratorMap lScanner = null;
        if (this.fConf.is("projection", "Cylindrical")) {
            lProjection = new ProjectionCyl();
            lScanner = new BitGeneratorMapDefault(lProjection);
            lShader = new ShaderDefault();
        }
        if (this.fConf.is("projection", "Mercator")) {
            lProjection = new ProjectionMerc();
            lScanner = new BitGeneratorMapDefault(lProjection);
            lShader = new ShaderDefault();
        }
        if (this.fConf.is("projection", "Orthographic")) {
            lProjection = new ProjectionOrtho();
            lScanner = new BitGeneratorMapOrtho(lProjection);
            lShader = new ShaderOrtho();
        }
        this.computePositions();
        lProjection.setImageWidth(this.fConf.getInt("imageWidth"));
        lProjection.setImageHeight(this.fConf.getInt("imageHeight"));
        lProjection.setShiftX(this.fConf.getInt("shiftX"));
        lProjection.setShiftY(this.fConf.getInt("shiftY"));
        lProjection.setViewMagnification(this.fConf.getDouble("viewMagnification"));
        lProjection.setViewPos(this.fViewPos);
        lProjection.setViewRotation(this.fViewRotation);
        lScanner.setImageWidth(this.fConf.getInt("imageWidth"));
        lScanner.setImageHeight(this.fConf.getInt("imageHeight"));
        lScanner.setMapData(MapDataReader.readMapData());
        lScanner.generateScanBits();
        ArrayList lScanDots = new ArrayList();
        if (this.fConf.getBoolean("starsP")) {
            lGenerator = new DotGeneratorStars(this.fConf.getInt("imageWidth"), this.fConf.getInt("imageHeight"), this.fConf.getDouble("starFrequency"), this.fConf.getInt("bigStars"), new Random(this.fCurrentTime));
            lGenerator.generateScanDots();
            lScanDots.addAll(lGenerator.getScanDots());
        }
        if (this.fConf.getBoolean("gridP")) {
            lGenerator = new DotGeneratorLines(lProjection, this.fConf.getInt("gridDivision"), this.fConf.getInt("gridPixelDivision"));
            lGenerator.generateScanDots();
            lScanDots.addAll(lGenerator.getScanDots());
        }
        QuickSort lSort = new QuickSort();
        Object[] lScanDotsArray = lScanDots.toArray(new ScanDot[0]);
        lSort.sort(lScanDotsArray);
        if (!this.fConf.getBoolean("shadeP")) {
            lShader = new ShaderFlat();
        }
        lShader.setProjection(lProjection);
        lShader.setSunPos(this.fConf.getSunPos());
        lShader.setDaySideBrightness(this.fConf.getInt("daySideBrightness"));
        lShader.setTerminatorDiscontinuity(this.fConf.getInt("terminatorDiscontinuity"));
        lShader.setNightSideBrightness(this.fConf.getInt("nightSideBrightness"));
        lShader.init();
        Renderer lRenderer = new Renderer(this.fCanvas);
        RowTypeRendererScanBit lRowRendererScanBit = new RowTypeRendererScanBit();
        lRowRendererScanBit.setScanBits(lScanner.getScanBits());
        lRenderer.addRowTypeRenderer(lRowRendererScanBit);
        RowTypeRendererScanDot lRowRendererScanDot = new RowTypeRendererScanDot();
        lRowRendererScanDot.setScanDots((ScanDot[])lScanDotsArray);
        lRenderer.addRowTypeRenderer(lRowRendererScanDot);
        lRenderer.setShader(lShader);
        lRenderer.render();
        for (Plugin lPlugin : this.fPlugins) {
            lPlugin.setProjection(lProjection);
            lPlugin.setRenderTarget(this.fCanvas);
            lPlugin.setParent(this);
            lPlugin.render();
        }
    }

    private void computePositions() {
        this.fCurrentTime = this.fConf.getInt("fixedTime") == 0 ? System.currentTimeMillis() : (long)this.fConf.getInt("fixedTime") * 1000L;
        if (this.fConf.getBoolean("sunMovesP")) {
            this.fConf.setSunPos(SunPositionCalculator.getSunPositionOnEarth(this.fCurrentTime));
        }
        if (this.fConf.is("viewPositionType", "Fixed")) {
            this.fViewPos = this.fConf.getViewPos();
        } else if (this.fConf.is("viewPositionType", "Sun-relative")) {
            this.fViewPos = this.getSunRelativePosition();
        } else if (this.fConf.is("viewPositionType", "Orbit")) {
            this.fViewPos = this.getOrbitPosition(this.fCurrentTime);
        } else if (this.fConf.is("viewPositionType", "Random")) {
            this.fViewPos = ACearth.getRandomPosition();
        } else if (this.fConf.is("viewPositionType", "Moon")) {
            this.fViewPos = SunPositionCalculator.getMoonPositionOnEarth(this.fCurrentTime);
        }
        this.fViewRotation = this.fConf.is("viewRotationType", "Galactic") ? Toolkit.degsToRads(this.fConf.getSunPos().getLat() * Math.sin(this.fViewPos.getLong() - this.fConf.getSunPos().getLong())) : this.fConf.getDouble("viewRotation");
    }

    private Coordinate getSunRelativePosition() {
        Coordinate lPos = this.fConf.getSunPos();
        lPos.add(this.fConf.getSunPosRel());
        return lPos;
    }

    private Coordinate getOrbitPosition(long pTimeMillis) {
        double x = 0.0;
        double y = 0.0;
        double z = 1.0;
        double a = (double)pTimeMillis / (this.fConf.getDouble("orbitPeriod") * 3600.0 * 1000.0) * 2.0 * Math.PI;
        double c = Math.cos(a);
        double s = Math.sin(a);
        double t1 = c * z - s * x;
        double t2 = s * z + c * x;
        z = t1;
        x = t2;
        a = Toolkit.degsToRads(this.fConf.getDouble("orbitInclination"));
        c = Math.cos(a);
        s = Math.sin(a);
        t1 = c * x - s * y;
        t2 = s * x + c * y;
        x = t1;
        y = t2;
        a = (double)pTimeMillis / 8.64E7 * (Math.PI * 2);
        c = Math.cos(a);
        s = Math.sin(a);
        t1 = c * x - s * z;
        t2 = s * x + c * z;
        x = t1;
        z = t2;
        return new Coordinate(Toolkit.radsToDegs(Math.asin(y)), Toolkit.radsToDegs(Math.atan2(x, z)));
    }

    private static Coordinate getRandomPosition() {
        int i;
        double[] pos = new double[3];
        double mag = 0.0;
        do {
            for (i = 0; i < 3; ++i) {
                pos[i] = Math.random() * 20000.0 * 1.0E-4 - 1.0;
                mag += pos[i] * pos[i];
            }
        } while (mag > 1.0 || mag < 0.01);
        mag = Math.sqrt(mag);
        i = 0;
        while (i < 3) {
            int n = i++;
            pos[n] = pos[n] / mag;
        }
        double s_lat = pos[1];
        double c_lat = Math.sqrt(1.0 - s_lat * s_lat);
        double s_lon = pos[0] / c_lat;
        double c_lon = pos[2] / c_lat;
        return new Coordinate(Math.atan2(s_lat, c_lat) * 57.29577951308232, Math.atan2(s_lon, c_lon) * 57.29577951308232);
    }

    public ConfigurationACearth getConf() {
        return this.fConf;
    }
}

