/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final ColorMapper colorMapper;
    private final double dpiFactor;
    private final HtmlColor mybackcolor;
    private final String metadata;
    private final String warningOrError;
    private final double margin1;
    private final double margin2;
    private final Animation affineTransformations;
    private final boolean useHandwritten;
    private UDrawable udrawable;

    public ImageBuilder(ColorMapper colorMapper, double dpiFactor, HtmlColor mybackcolor, String metadata, String warningOrError, double margin1, double margin2, Animation affineTransformations, boolean useHandwritten) {
        this.colorMapper = colorMapper;
        this.dpiFactor = dpiFactor;
        this.mybackcolor = mybackcolor;
        this.metadata = metadata;
        this.warningOrError = warningOrError;
        this.margin1 = margin1;
        this.margin2 = margin2;
        this.affineTransformations = affineTransformations;
        this.useHandwritten = useHandwritten;
    }

    public void addUDrawable(UDrawable udrawable) {
        this.udrawable = udrawable;
    }

    public ImageData writeImageTOBEMOVED(FileFormatOption fileFormatOption, OutputStream os) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.MJPEG) {
            return this.writeImageMjpeg(os);
        }
        if (fileFormat == FileFormat.ANIMATED_GIF) {
            return this.writeImageAnimatedGif(os);
        }
        return this.writeImageTOBEMOVED(fileFormatOption, os, this.affineTransformations);
    }

    private ImageData writeImageTOBEMOVED(FileFormatOption fileFormatOption, OutputStream os, Animation affineTransforms) throws IOException {
        Set<Url> urls;
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2D dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        double dx = 0.0;
        double dy = 0.0;
        if (affineTransforms != null) {
            MinMax minmax = this.affineTransformations.getMinMax(dim);
            affineTransforms.setDimension(dim);
            dim = minmax.getDimension();
            dx = -minmax.getMinX();
            dy = -minmax.getMinY();
        }
        UGraphic2 ug = this.createUGraphic(fileFormatOption, dim, affineTransforms, dx, dy);
        this.udrawable.drawU(this.handwritten(ug.apply(new UTranslate(this.margin1, this.margin1))));
        ug.flushUg();
        ug.writeImageTOBEMOVED(os, this.metadata, 96);
        os.flush();
        if (ug instanceof UGraphicG2d && (urls = ((UGraphicG2d)ug).getAllUrlsEncountered()).size() > 0) {
            CMapData cmap = CMapData.cmapString(urls, this.dpiFactor);
            return new ImageDataComplex(dim, cmap, this.warningOrError);
        }
        return new ImageDataSimple(dim);
    }

    private UGraphic handwritten(UGraphic ug) {
        if (this.useHandwritten) {
            return new UGraphicHandwritten(ug);
        }
        return ug;
    }

    private ImageData writeImageMjpeg(OutputStream os) throws IOException {
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        File f = new File("c:/tmp.avi");
        int nbframe = 100;
        MJPEGGenerator m = new MJPEGGenerator(f, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int i = 0;
        if (i < 100) {
            AffineTransform at = AffineTransform.getTranslateInstance(((Dimension2D)dim).getWidth() / 2.0, ((Dimension2D)dim).getHeight() / 2.0);
            at.rotate(1.5707963267948966 * (double)i / 100.0);
            at.translate(-((Dimension2D)dim).getWidth() / 2.0, -((Dimension2D)dim).getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        m.finishAVI();
        FileUtils.copyToStream(f, os);
        return new ImageDataSimple(dim);
    }

    private ImageData writeImageAnimatedGif(OutputStream os) throws IOException {
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dim = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        MinMax minmax = this.affineTransformations.getMinMax(dim);
        AnimatedGifEncoder e = new AnimatedGifEncoder();
        e.setRepeat(0);
        e.start(os);
        e.setDelay(60);
        for (AffineTransformation at : this.affineTransformations.getAll()) {
            ImageIcon ii = new ImageIcon(this.getAviImage(at));
            e.addFrame((BufferedImage)ii.getImage());
        }
        e.finish();
        return new ImageDataSimple(dim);
    }

    private Image getAviImage(AffineTransformation affineTransform) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), baos, Animation.singleton(affineTransform));
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedImage im = ImageIO.read(bais);
        bais.close();
        return im;
    }

    private UGraphic2 createUGraphic(FileFormatOption fileFormatOption, Dimension2D dim, Animation affineTransforms, double dx, double dy) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        switch (fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(this.colorMapper, this.dpiFactor, dim, this.mybackcolor, affineTransforms, dx, dy);
            }
            case SVG: {
                return this.createUGraphicSVG(this.colorMapper, this.dpiFactor, dim, this.mybackcolor, fileFormatOption.getSvgLinkTarget());
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper);
            }
        }
        throw new UnsupportedOperationException(fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double scale, Dimension2D dim, HtmlColor mybackcolor, String svgLinkTarget) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        }
        UGraphicSvg ug = mybackcolor instanceof HtmlColorGradient ? new UGraphicSvg(colorMapper, (HtmlColorGradient)mybackcolor, false, scale, svgLinkTarget) : (backColor == null || backColor.equals(Color.WHITE) ? new UGraphicSvg(colorMapper, false, scale, svgLinkTarget) : new UGraphicSvg(colorMapper, StringUtils.getAsHtml(backColor), false, scale, svgLinkTarget));
        return ug;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double dpiFactor, Dimension2D dim, HtmlColor mybackcolor, Animation affineTransforms, double dx, double dy) {
        Color backColor = Color.WHITE;
        if (mybackcolor instanceof HtmlColorSimple) {
            backColor = colorMapper.getMappedColor(mybackcolor);
        } else if (mybackcolor instanceof HtmlColorTransparent) {
            backColor = null;
        }
        EmptyImageBuilder builder = new EmptyImageBuilder((int)(dim.getWidth() * dpiFactor), (int)(dim.getHeight() * dpiFactor), backColor);
        Graphics2D graphics2D = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(colorMapper, graphics2D, dpiFactor, affineTransforms == null ? null : affineTransforms.getFirst(), dx, dy);
        ug.setBufferedImage(builder.getBufferedImage());
        BufferedImage im = ug.getBufferedImage();
        if (mybackcolor instanceof HtmlColorGradient) {
            ug.apply(new UChangeBackColor(mybackcolor)).draw(new URectangle(im.getWidth(), im.getHeight()));
        }
        return ug;
    }
}

