/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockGeneric;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageClassHeader2
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader2(ILeaf entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        TextBlock genericBlock;
        boolean italic = entity.getEntityType() == LeafType.ABSTRACT_CLASS || entity.getEntityType() == LeafType.INTERFACE;
        HtmlColor color = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS, this.getStereo());
        Stereotype stereotype = entity.getStereotype();
        String generic = entity.getGeneric();
        FontConfiguration fontConfigurationName = new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype);
        if (italic) {
            fontConfigurationName = fontConfigurationName.italic();
        }
        TextBlock name = TextBlockUtils.withMargin(entity.getDisplay().createWithNiceCreoleMode(fontConfigurationName, HorizontalAlignment.CENTER, skinParam), 3.0, 3.0, 0.0, 0.0);
        TextBlock stereo = stereotype == null || stereotype.getLabel(false) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? null : TextBlockUtils.withMargin(Display.create(stereotype.getLabels(skinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam), 1.0, 0.0);
        if (generic == null) {
            genericBlock = null;
        } else {
            genericBlock = Display.getWithNewlines(generic).create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
            HtmlColor classBackground = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.background, stereotype);
            HtmlColor classBorder = SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CLASS_STEREOTYPE, stereotype);
            genericBlock = new TextBlockGeneric(genericBlock, classBackground, classBorder);
            genericBlock = TextBlockUtils.withMargin(genericBlock, 1.0, 1.0);
        }
        TextBlock circledCharacter = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, (ILeaf)this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(entity, skinParam), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout(circledCharacter, stereo, name, genericBlock);
    }

    private TextBlock getCircledCharacter(ILeaf entity, ISkinParam skinParam) {
        Stereotype stereotype = entity.getStereotype();
        if (stereotype != null && stereotype.getSprite() != null) {
            return skinParam.getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor());
        }
        UFont font = SkinParamUtils.getFont(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null);
        HtmlColor classBorder = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.classBorder, stereotype);
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), font, stereotype.getHtmlColor(), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (entity.getEntityType() == LeafType.ANNOTATION) {
            return new CircledCharacter('@', this.getSkinParam().getCircledCharacterRadius(), font, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeABackground, stereotype), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (entity.getEntityType() == LeafType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', this.getSkinParam().getCircledCharacterRadius(), font, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeABackground, stereotype), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (entity.getEntityType() == LeafType.CLASS) {
            return new CircledCharacter('C', this.getSkinParam().getCircledCharacterRadius(), font, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeCBackground, stereotype), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (entity.getEntityType() == LeafType.INTERFACE) {
            return new CircledCharacter('I', this.getSkinParam().getCircledCharacterRadius(), font, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeIBackground, stereotype), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        if (entity.getEntityType() == LeafType.ENUM) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), font, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.stereotypeEBackground, stereotype), classBorder, SkinParamUtils.getFontColor(this.getSkinParam(), FontParam.CIRCLED_CHARACTER, null));
        }
        assert (false);
        return null;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic ug, double width, double height) {
        this.headerLayout.drawU(ug, width, height);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

