/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersions;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;

public class DotStringFactory
implements Moveable {
    private final Bibliotekon bibliotekon = new Bibliotekon();
    private final Set<String> rankMin = new HashSet<String>();
    private final ColorSequence colorSequence;
    private final Cluster root;
    private Cluster current;
    private final DotData dotData;
    private final StringBounder stringBounder;

    public DotStringFactory(ColorSequence colorSequence, StringBounder stringBounder, DotData dotData) {
        this.colorSequence = colorSequence;
        this.dotData = dotData;
        this.stringBounder = stringBounder;
        this.current = this.root = new Cluster(colorSequence, dotData.getSkinParam(), dotData.getRootGroup());
    }

    public void addShape(Shape shape) {
        this.current.addShape(shape);
    }

    private void printMinRanking(StringBuilder sb) {
        if (this.rankMin.size() == 0) {
            return;
        }
        sb.append("{ rank = min;");
        for (String id : this.rankMin) {
            sb.append(id);
            sb.append(";");
        }
        sb.append("}");
    }

    private double getHorizontalDzeta() {
        double max = 0.0;
        for (Line l : this.bibliotekon.allLines()) {
            double c = l.getHorizontalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    private double getVerticalDzeta() {
        double max = 0.0;
        for (Line l : this.bibliotekon.allLines()) {
            double c = l.getVerticalDzeta(this.stringBounder);
            if (!(c > max)) continue;
            max = c;
        }
        return max / 10.0;
    }

    String createDotString(String ... dotStrings) {
        StringBuilder sb = new StringBuilder();
        double nodesep = this.getHorizontalDzeta();
        if (nodesep < (double)this.getMinNodeSep()) {
            nodesep = this.getMinNodeSep();
        }
        if (this.dotData.getSkinParam().getNodesep() != 0.0) {
            nodesep = this.dotData.getSkinParam().getNodesep();
        }
        String nodesepInches = SvekUtils.pixelToInches(nodesep);
        double ranksep = this.getVerticalDzeta();
        if (ranksep < (double)this.getMinRankSep()) {
            ranksep = this.getMinRankSep();
        }
        if (this.dotData.getSkinParam().getRanksep() != 0.0) {
            ranksep = this.dotData.getSkinParam().getRanksep();
        }
        String ranksepInches = SvekUtils.pixelToInches(ranksep);
        sb.append("digraph unix {");
        SvekUtils.println(sb);
        for (String s : dotStrings) {
            if (s.startsWith("ranksep")) {
                sb.append("ranksep=" + ranksepInches + ";");
            } else if (s.startsWith("nodesep")) {
                sb.append("nodesep=" + nodesepInches + ";");
            } else {
                sb.append(s);
            }
            SvekUtils.println(sb);
        }
        sb.append("remincross=true;");
        SvekUtils.println(sb);
        sb.append("searchsize=500;");
        SvekUtils.println(sb);
        if (this.dotData.getSkinParam().getRankdir() == Rankdir.LEFT_TO_RIGHT) {
            sb.append("rankdir=LR;");
            SvekUtils.println(sb);
        }
        this.manageMinMaxCluster(sb);
        this.root.printCluster1(sb, this.bibliotekon.allLines());
        for (Line line : this.bibliotekon.lines0()) {
            line.appendLine(sb);
        }
        this.root.fillRankMin(this.rankMin);
        this.root.printCluster2(sb, this.bibliotekon.allLines(), this.stringBounder, this.dotData.getDotMode(), this.getGraphvizVersion(), this.dotData.getUmlDiagramType());
        this.printMinRanking(sb);
        for (Line line : this.bibliotekon.lines1()) {
            line.appendLine(sb);
        }
        SvekUtils.println(sb);
        sb.append("}");
        return sb.toString();
    }

    private void manageMinMaxCluster(StringBuilder sb) {
        ArrayList<String> minPointCluster = new ArrayList<String>();
        ArrayList<String> maxPointCluster = new ArrayList<String>();
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            String maxPoint;
            String minPoint = cluster.getMinPoint(this.dotData.getUmlDiagramType());
            if (minPoint != null) {
                minPointCluster.add(minPoint);
            }
            if ((maxPoint = cluster.getMaxPoint(this.dotData.getUmlDiagramType())) == null) continue;
            maxPointCluster.add(maxPoint);
        }
        if (minPointCluster.size() > 0) {
            sb.append("{rank=min;");
            for (String s : minPointCluster) {
                sb.append(s);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
        if (maxPointCluster.size() > 0) {
            sb.append("{rank=max;");
            for (String s : maxPointCluster) {
                sb.append(s);
                sb.append(" [shape=point,width=.01,label=\"\"]");
                sb.append(";");
            }
            sb.append("}");
            SvekUtils.println(sb);
        }
    }

    private int getMinRankSep() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return 40;
        }
        return 60;
    }

    private int getMinNodeSep() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return 20;
        }
        return 35;
    }

    public GraphvizVersion getGraphvizVersion() {
        Graphviz graphviz = GraphvizUtils.create("foo;", "svg");
        File f = graphviz.getDotExe();
        return GraphvizVersions.getInstance().getVersion(f);
    }

    public String getSvg(boolean trace, String ... dotStrings) throws IOException {
        String dotString = this.createDotString(dotStrings);
        if (trace) {
            Log.info("Creating temporary file svek.dot");
            SvekUtils.traceDotString(dotString);
        }
        Graphviz graphviz = GraphvizUtils.create(dotString, "svg");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProcessState state = graphviz.createFile3(baos);
        baos.close();
        if (state.differs(ProcessState.TERMINATED_OK())) {
            throw new IllegalStateException("Timeout4 " + state, state.getCause());
        }
        byte[] result = baos.toByteArray();
        String s = new String(result, "UTF-8");
        if (trace) {
            Log.info("Creating temporary file svek.svg");
            SvekUtils.traceSvgString(s);
        }
        return s;
    }

    public boolean illegalDotExe() {
        Graphviz graphviz = GraphvizUtils.create(null, "svg");
        File dotExe = graphviz.getDotExe();
        return dotExe == null || !dotExe.isFile() || !dotExe.canRead();
    }

    public File getDotExe() {
        Graphviz graphviz = GraphvizUtils.create(null, "svg");
        return graphviz.getDotExe();
    }

    public ClusterPosition solve(String svg) throws IOException, InterruptedException {
        double minY;
        double minX;
        int idx;
        if (svg.length() == 0) {
            throw new EmptySvgException();
        }
        Pattern pGraph = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"");
        Matcher mGraph = pGraph.matcher(svg);
        if (!mGraph.find()) {
            throw new IllegalStateException();
        }
        int fullWidth = Integer.parseInt(mGraph.group(1));
        int fullHeight = Integer.parseInt(mGraph.group(2));
        MinFinder corner1 = new MinFinder();
        for (Shape sh : this.bibliotekon.allShapes()) {
            idx = svg.indexOf("<title>" + sh.getUid() + "</title>");
            if (sh.getType() == ShapeType.RECTANGLE || sh.getType() == ShapeType.FOLDER || sh.getType() == ShapeType.DIAMOND) {
                List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                corner1.manage(minX, minY);
                sh.moveSvek(minX, minY);
                continue;
            }
            if (sh.getType() == ShapeType.ROUND_RECTANGLE) {
                List<Point2D.Double> points;
                int idx2 = svg.indexOf("d=\"", idx + 1);
                idx = svg.indexOf("points=\"", idx + 1);
                if (idx2 != -1 && (idx == -1 || idx2 < idx)) {
                    points = SvekUtils.extractD(svg, idx2, fullHeight);
                } else {
                    points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                    for (int i = 0; i < 3; ++i) {
                        idx = svg.indexOf("points=\"", idx + 1);
                        points.addAll(SvekUtils.extractPointsList(svg, idx, fullHeight));
                    }
                }
                double minX2 = SvekUtils.getMinX(points);
                double minY2 = SvekUtils.getMinY(points);
                corner1.manage(minX2, minY2);
                sh.moveSvek(minX2, minY2);
                continue;
            }
            if (sh.getType() == ShapeType.OCTAGON) {
                idx = svg.indexOf("points=\"", idx + 1);
                List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
                minX = SvekUtils.getMinX(points);
                minY = SvekUtils.getMinY(points);
                corner1.manage(minX, minY);
                sh.moveSvek(minX, minY);
                sh.setOctagon(minX, minY, points);
                continue;
            }
            if (sh.getType() == ShapeType.CIRCLE || sh.getType() == ShapeType.CIRCLE_IN_RECT || sh.getType() == ShapeType.OVAL) {
                double cx = SvekUtils.getValue(svg, idx, "cx");
                double cy = SvekUtils.getValue(svg, idx, "cy") + (double)fullHeight;
                double rx = SvekUtils.getValue(svg, idx, "rx");
                double ry = SvekUtils.getValue(svg, idx, "ry");
                sh.moveSvek(cx - rx, cy - ry);
                continue;
            }
            throw new IllegalStateException(sh.getType().toString() + " " + sh.getUid());
        }
        for (Cluster cluster : this.bibliotekon.allCluster()) {
            idx = this.getClusterIndex(svg, cluster.getColor());
            List<Point2D.Double> points = SvekUtils.extractPointsList(svg, idx, fullHeight);
            minX = SvekUtils.getMinX(points);
            minY = SvekUtils.getMinY(points);
            double maxX = SvekUtils.getMaxX(points);
            double maxY = SvekUtils.getMaxY(points);
            cluster.setPosition(minX, minY, maxX, maxY);
            corner1.manage(minX, minY);
            if (cluster.getTitleAndAttributeWidth() == 0 || cluster.getTitleAndAttributeHeight() == 0) continue;
            idx = this.getClusterIndex(svg, cluster.getTitleColor());
            List<Point2D.Double> pointsTitle = SvekUtils.extractPointsList(svg, idx, fullHeight);
            double minXtitle = SvekUtils.getMinX(pointsTitle);
            double minYtitle = SvekUtils.getMinY(pointsTitle);
            cluster.setTitlePosition(minXtitle, minYtitle);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.solveLine(svg, fullHeight, corner1, this.dotData);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.manageCollision(this.bibliotekon.allShapes());
        }
        corner1.manage(0.0, 0.0);
        return new ClusterPosition(corner1.getMinX(), corner1.getMinY(), fullWidth, fullHeight);
    }

    private int getClusterIndex(String svg, int colorInt) {
        String colorString = StringUtils.goLowerCase(StringUtils.getAsHtml(colorInt));
        String keyTitle1 = "=\"" + colorString + "\"";
        int idx = svg.indexOf(keyTitle1);
        if (idx == -1) {
            String keyTitle2 = "stroke:" + colorString + ";";
            idx = svg.indexOf(keyTitle2);
        }
        if (idx == -1) {
            throw new IllegalStateException("Cannot find color " + colorString);
        }
        return idx;
    }

    public void openCluster(IGroup g, int titleAndAttributeWidth, int titleAndAttributeHeight, TextBlock title, TextBlock stereo) {
        this.current = this.current.createChild(g, titleAndAttributeWidth, titleAndAttributeHeight, title, stereo, this.colorSequence, this.dotData.getSkinParam());
        this.bibliotekon.addCluster(this.current);
    }

    public void closeCluster() {
        if (this.current.getParent() == null) {
            throw new IllegalStateException();
        }
        this.current = this.current.getParent();
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        for (Shape sh : this.bibliotekon.allShapes()) {
            sh.moveSvek(deltaX, deltaY);
        }
        for (Line line : this.bibliotekon.allLines()) {
            line.moveSvek(deltaX, deltaY);
        }
        for (Cluster cl : this.bibliotekon.allCluster()) {
            cl.moveSvek(deltaX, deltaY);
        }
    }

    public final Bibliotekon getBibliotekon() {
        return this.bibliotekon;
    }
}

