/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DecorateTextBlock
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock original;
    private final HorizontalAlignment horizontal1;
    private final TextBlock text1;
    private final HorizontalAlignment horizontal2;
    private final TextBlock text2;
    private double deltaX;
    private double deltaY;

    public DecorateTextBlock(TextBlock original, TextBlock text, HorizontalAlignment horizontal) {
        this(original, text, horizontal, null, null);
    }

    public DecorateTextBlock(TextBlock original, TextBlock text1, HorizontalAlignment horizontal1, TextBlock text2, HorizontalAlignment horizontal2) {
        this.original = original;
        this.horizontal1 = horizontal1;
        this.text1 = text1;
        this.horizontal2 = horizontal2;
        this.text2 = text2;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        Dimension2D dimText1 = this.getTextDim(this.text1, stringBounder);
        Dimension2D dimText2 = this.getTextDim(this.text2, stringBounder);
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double yText1 = 0.0;
        double yImage = 0.0 + dimText1.getHeight();
        double yText2 = yImage + dimOriginal.getHeight();
        double xImage = (dimTotal.getWidth() - dimOriginal.getWidth()) / 2.0;
        if (this.text1 != null) {
            double xText1 = this.getTextX(dimText1, dimTotal, this.horizontal1);
            this.text1.drawU(ug.apply(new UTranslate(xText1, 0.0)));
        }
        this.original.drawU(ug.apply(new UTranslate(xImage, yImage)));
        this.deltaX = xImage;
        this.deltaY = yImage;
        if (this.text2 != null) {
            double xText2 = this.getTextX(dimText2, dimTotal, this.horizontal2);
            this.text2.drawU(ug.apply(new UTranslate(xText2, yText2)));
        }
    }

    private Dimension2D getTextDim(TextBlock text, StringBounder stringBounder) {
        if (text == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return text.calculateDimension(stringBounder);
    }

    private double getTextX(Dimension2D dimText, Dimension2D dimTotal, HorizontalAlignment h) {
        if (h == HorizontalAlignment.CENTER) {
            return (dimTotal.getWidth() - dimText.getWidth()) / 2.0;
        }
        if (h == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (h == HorizontalAlignment.RIGHT) {
            return dimTotal.getWidth() - dimText.getWidth();
        }
        throw new IllegalStateException();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        Dimension2D dimText = Dimension2DDouble.mergeTB(this.getTextDim(this.text1, stringBounder), this.getTextDim(this.text2, stringBounder));
        return Dimension2DDouble.mergeTB(dimOriginal, dimText);
    }

    private double getDeltaX() {
        if (this.original instanceof DecorateTextBlock) {
            return this.deltaX + ((DecorateTextBlock)this.original).deltaX;
        }
        return this.deltaX;
    }

    private double getDeltaY() {
        if (this.original instanceof DecorateTextBlock) {
            return this.deltaY + ((DecorateTextBlock)this.original).deltaY;
        }
        return this.deltaY;
    }
}

