/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SequenceDiagramFileMakerPuma2
implements FileMaker {
    private static final StringBounder dummyStringBounder = TextBlockUtils.getDummyStringBounder();
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private double scale;

    public SequenceDiagramFileMakerPuma2(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption) {
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer initializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant participant : sequenceDiagram.participants().values()) {
            initializer.addParticipant(participant, sequenceDiagram.getEnglober(participant));
        }
        for (Event event : sequenceDiagram.events()) {
            initializer.addEvent(event);
        }
        this.drawableSet = initializer.createDrawableSet(dummyStringBounder);
        ArrayList<Newpage> newpages = new ArrayList<Newpage>();
        for (Event ev : this.drawableSet.getAllEvents()) {
            if (!(ev instanceof Newpage)) continue;
            newpages.add((Newpage)ev);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        for (Newpage n : newpages) {
            linkedHashMap.put(n, initializer.getYposition(dummyStringBounder, n));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> positions, boolean showFootbox, Display title) {
        double headerHeight = drawableSet.getHeadHeight(dummyStringBounder);
        double tailHeight = drawableSet.getTailHeight(dummyStringBounder, showFootbox);
        double signatureHeight = 0.0;
        double newpageHeight = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Display.create("")).getPreferredHeight(dummyStringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), headerHeight, positions, tailHeight, 0.0, newpageHeight, title);
    }

    @Override
    public ImageData createOne(OutputStream os, final int index, boolean isWithMetadata) throws IOException {
        Component compTitle;
        final Page page = this.pages.get(index);
        final SequenceDiagramArea area = new SequenceDiagramArea(this.fullDimension.getWidth(), page.getHeight());
        if (Display.isNull(page.getTitle())) {
            compTitle = null;
        } else {
            compTitle = this.drawableSet.getSkin().createComponent(ComponentType.TITLE, null, this.drawableSet.getSkinParam(), page.getTitle());
            area.setTitleArea(compTitle.getPreferredWidth(dummyStringBounder), compTitle.getPreferredHeight(dummyStringBounder));
        }
        this.addFooter2(area);
        this.addHeader2(area);
        final Display legend = this.diagram.getLegend();
        final TextBlock legendBlock = Display.isNull(legend) ? TextBlockUtils.empty(0.0, 0.0) : EntityImageLegend.create(legend, this.diagram.getSkinParam());
        final Dimension2D dimLegend = TextBlockUtils.getDimension(legendBlock);
        this.scale = this.getScale(area.getWidth(), area.getHeight());
        double dpiFactor = this.diagram.getDpiFactor(this.fileFormatOption);
        String metadata = this.fileFormatOption.isWithMetadata() ? this.diagram.getMetadata() : null;
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam().getColorMapper(), this.oneOf(this.scale, dpiFactor), this.diagram.getSkinParam().getBackgroundColor(), metadata, null, 3.0, 10.0, this.diagram.getAnimation(), this.diagram.getSkinParam().handwritten());
        imageBuilder.addUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                double delta = 0.0;
                if (index > 0) {
                    delta = page.getNewpage1() - page.getHeaderHeight();
                }
                if (delta < 0.0) {
                    delta = 0.0;
                }
                double legendYdelta = 0.0;
                if (compTitle != null) {
                    StringBounder stringBounder = ug.getStringBounder();
                    double h = compTitle.getPreferredHeight(stringBounder);
                    legendYdelta += h;
                    double w = compTitle.getPreferredWidth(stringBounder);
                    compTitle.drawU(ug.apply(new UTranslate(area.getTitleX(), area.getTitleY())), new Area(new Dimension2DDouble(w, h)), new SimpleContext2D(false));
                }
                double delta1 = Math.max(0.0, dimLegend.getWidth() - area.getWidth());
                boolean legendTop = !Display.isNull(legend) && SequenceDiagramFileMakerPuma2.this.diagram.getLegendVerticalAlignment() == VerticalAlignment.TOP;
                double sequenceAreaY = area.getSequenceAreaY();
                if (legendTop) {
                    sequenceAreaY += legendBlock.calculateDimension(ug.getStringBounder()).getHeight();
                }
                SequenceDiagramFileMakerPuma2.this.drawableSet.drawU22(ug.apply(new UTranslate(area.getSequenceAreaX() + delta1 / 2.0, sequenceAreaY)), delta, SequenceDiagramFileMakerPuma2.this.fullDimension.getWidth(), page, SequenceDiagramFileMakerPuma2.this.diagram.isShowFootbox());
                SequenceDiagramFileMakerPuma2.this.addHeader3(area, ug);
                SequenceDiagramFileMakerPuma2.this.addFooter3(area, ug);
                if (!Display.isNull(legend)) {
                    double delta2 = SequenceDiagramFileMakerPuma2.this.diagram.getLegendAlignment() == HorizontalAlignment.LEFT ? 0.0 : (SequenceDiagramFileMakerPuma2.this.diagram.getLegendAlignment() == HorizontalAlignment.RIGHT ? Math.max(0.0, area.getWidth() - dimLegend.getWidth()) : Math.max(0.0, area.getWidth() - dimLegend.getWidth()) / 2.0);
                    legendBlock.drawU(ug.apply(new UTranslate(delta2, legendTop ? legendYdelta : legendYdelta + area.getHeight())));
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(this.fileFormatOption, os);
    }

    private double oneOf(double a, double b) {
        if (a == 1.0) {
            return b;
        }
        return a;
    }

    private double getImageWidth(SequenceDiagramArea area, double dpiFactor, double legendWidth) {
        int minsize = this.diagram.getMinwidth();
        double w = Math.max(area.getWidth() * this.getScale(area.getWidth(), area.getHeight()) * dpiFactor, legendWidth);
        if (minsize == Integer.MAX_VALUE) {
            return w;
        }
        if (w >= (double)minsize) {
            return w;
        }
        return minsize;
    }

    private double getScale(double width, double height) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(width, height);
    }

    private void addFooter2(SequenceDiagramArea area) {
        HtmlColor hyperlinkColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.diagram.getSkinParam().getFontHtmlColor(null, FontParam.FOOTER);
        String fontFamily = this.diagram.getSkinParam().getFont(null, false, FontParam.FOOTER).getFamily(null);
        int fontSize = this.diagram.getSkinParam().getFont(null, false, FontParam.FOOTER).getSize();
        PngTitler pngTitler = new PngTitler(titleColor, this.diagram.getFooter(), fontSize, fontFamily, this.diagram.getFooterAlignment(), hyperlinkColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        Dimension2D dim = pngTitler.getTextDimension(dummyStringBounder);
        if (dim != null) {
            area.setFooterArea(dim.getWidth(), dim.getHeight(), 3.0);
        }
    }

    private void addHeader2(SequenceDiagramArea area) {
        HtmlColor hyperlinkColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.diagram.getSkinParam().getFontHtmlColor(null, FontParam.HEADER);
        String fontFamily = this.diagram.getSkinParam().getFont(null, false, FontParam.HEADER).getFamily(null);
        int fontSize = this.diagram.getSkinParam().getFont(null, false, FontParam.HEADER).getSize();
        PngTitler pngTitler = new PngTitler(titleColor, this.diagram.getHeader(), fontSize, fontFamily, this.diagram.getHeaderAlignment(), hyperlinkColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        Dimension2D dim = pngTitler.getTextDimension(dummyStringBounder);
        if (dim != null) {
            area.setHeaderArea(dim.getWidth(), dim.getHeight(), 3.0);
        }
    }

    private void addFooter3(SequenceDiagramArea area, UGraphic ug) {
        HtmlColor hyperlinkColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.diagram.getSkinParam().getFontHtmlColor(null, FontParam.FOOTER);
        String fontFamily = this.diagram.getSkinParam().getFont(null, false, FontParam.FOOTER).getFamily(null);
        int fontSize = this.diagram.getSkinParam().getFont(null, false, FontParam.FOOTER).getSize();
        PngTitler pngTitler = new PngTitler(titleColor, this.diagram.getFooter(), fontSize, fontFamily, this.diagram.getFooterAlignment(), hyperlinkColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        TextBlock text = pngTitler.getTextBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getFooterX(this.diagram.getFooterAlignment()), area.getFooterY())));
    }

    private void addHeader3(SequenceDiagramArea area, UGraphic ug) {
        HtmlColor hyperlinkColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor titleColor = this.diagram.getSkinParam().getFontHtmlColor(null, FontParam.HEADER);
        String fontFamily = this.diagram.getSkinParam().getFont(null, false, FontParam.HEADER).getFamily(null);
        int fontSize = this.diagram.getSkinParam().getFont(null, false, FontParam.HEADER).getSize();
        PngTitler pngTitler = new PngTitler(titleColor, this.diagram.getHeader(), fontSize, fontFamily, this.diagram.getHeaderAlignment(), hyperlinkColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        TextBlock text = pngTitler.getTextBlock();
        if (text == null) {
            return;
        }
        text.drawU(ug.apply(new UTranslate(area.getHeaderX(this.diagram.getHeaderAlignment()), area.getHeaderY())));
    }
}

