/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(File f, int num, String charset) throws IOException {
        this(StartDiagramExtractReader.getReadLine(f, charset), num, charset);
    }

    public StartDiagramExtractReader(URL url, int num, String charset) throws IOException {
        this(StartDiagramExtractReader.getReadLine(url, charset), num, charset);
    }

    private StartDiagramExtractReader(ReadLine raw, int num, String charset) throws IOException {
        if (num < 0) {
            throw new IllegalArgumentException();
        }
        this.raw = raw;
        CharSequence2 s = null;
        while ((s = raw.readLine()) != null) {
            if (!StartUtils.isArobaseStartDiagram(s)) continue;
            if (num == 0) {
                return;
            }
            --num;
        }
        this.finished = true;
    }

    private static ReadLine getReadLine(File f, String charset) throws IOException {
        if (charset == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new FileReader(f), f.getAbsolutePath()));
        }
        Log.info("Using charset " + charset);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(f), charset), f.getAbsolutePath()));
    }

    private static ReadLine getReadLine(URL url, String charset) throws IOException {
        if (charset == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new InputStreamReader(url.openStream()), url.toString()));
        }
        Log.info("Using charset " + charset);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader(url.openStream(), charset), url.toString()));
    }

    public static boolean containsStartDiagram(File f, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(f, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(URL url, String charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(url, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    private static boolean containsStartDiagram(ReadLine r) throws IOException {
        try {
            CharSequence2 s = null;
            while ((s = r.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return false;
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        CharSequence2 result = this.raw.readLine();
        if (result != null && StartUtils.isArobaseEndDiagram(result)) {
            this.finished = true;
            return null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }
}

