/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngSegment;

public class PngSplitter {
    private final List<File> files = new ArrayList<File>();

    public static void main(String[] args) throws IOException {
        File f = new File(args[0]);
        int x = Integer.parseInt(args[1]);
        int y = Integer.parseInt(args[2]);
        File cp = new File(f.getParent(), f.getName().replaceAll("\\.png$", "_000.png"));
        FileUtils.copyToFile(f, cp);
        new PngSplitter(cp, x, y, "", 96, false);
    }

    public PngSplitter(File pngFile, int horizontalPages, int verticalPages, String source, int dpi, boolean isWithMetadata) throws IOException {
        if (horizontalPages == 1 && verticalPages == 1) {
            this.files.add(pngFile);
            return;
        }
        Log.info("Splitting " + horizontalPages + " x " + verticalPages);
        File full = new File(pngFile.getParentFile(), pngFile.getName() + ".tmp");
        Thread.yield();
        full.delete();
        Thread.yield();
        boolean ok = pngFile.renameTo(full);
        Thread.yield();
        if (!ok) {
            throw new IOException("Cannot rename");
        }
        Thread.yield();
        BufferedImage im = ImageIO.read(full);
        Thread.yield();
        PngSegment horizontalSegment = new PngSegment(im.getWidth(), horizontalPages);
        PngSegment verticalSegment = new PngSegment(im.getHeight(), verticalPages);
        int x = 0;
        for (int i = 0; i < horizontalPages; ++i) {
            for (int j = 0; j < verticalPages; ++j) {
                File f = FileFormat.PNG.computeFilename(pngFile, x++);
                this.files.add(f);
                BufferedImage imPiece = im.getSubimage(horizontalSegment.getStart(i), verticalSegment.getStart(j), horizontalSegment.getLen(i), verticalSegment.getLen(j));
                Thread.yield();
                PngIO.write((RenderedImage)imPiece, f, isWithMetadata ? source : null, dpi);
                Thread.yield();
            }
        }
        full.delete();
        Log.info("End of splitting");
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }
}

