/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.awt.geom.Dimension2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.openiconic.SvgPath;
import net.sourceforge.plantuml.openiconic.data.DummyIcon;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class OpenIcon {
    private SvgPath svgPath;
    private List<String> rawData = new ArrayList<String>();
    private final String id;

    public static OpenIcon retrieve(String name) {
        InputStream is = OpenIcon.getRessource(name);
        if (is == null) {
            return null;
        }
        try {
            return new OpenIcon(is, name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    OpenIcon(String name) throws IOException {
        this(OpenIcon.getRessource(name), name);
    }

    private static InputStream getRessource(String name) {
        return DummyIcon.class.getResourceAsStream(name + ".svg");
    }

    private OpenIcon(InputStream is, String id) throws IOException {
        this.id = id;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String s = null;
        while ((s = br.readLine()) != null) {
            this.rawData.add(s);
            if (!s.contains("<path")) continue;
            int x1 = s.indexOf(34);
            int x2 = s.indexOf(34, x1 + 1);
            this.svgPath = new SvgPath(s.substring(x1 + 1, x2));
        }
        br.close();
        is.close();
        if (this.rawData.size() != 3 && this.rawData.size() != 4) {
            throw new IllegalStateException();
        }
    }

    void saveCopy(File fnew) throws IOException {
        PrintWriter pw = new PrintWriter(fnew);
        pw.println(this.rawData.get(0));
        pw.println(this.svgPath.toSvg());
        pw.println(this.rawData.get(this.rawData.size() - 1));
        pw.close();
    }

    private Dimension2D getDimension(double factor) {
        String width = this.getNumber(this.rawData.get(0), "width");
        String height = this.getNumber(this.rawData.get(0), "height");
        return new Dimension2DDouble((double)Integer.parseInt(width) * factor, (double)Integer.parseInt(height) * factor);
    }

    private String getNumber(String s, String arg) {
        int x1 = s.indexOf(arg);
        if (x1 == -1) {
            throw new IllegalArgumentException();
        }
        if ((x1 = s.indexOf("\"", x1)) == -1) {
            throw new IllegalArgumentException();
        }
        int x2 = s.indexOf("\"", x1 + 1);
        if (x2 == -1) {
            throw new IllegalArgumentException();
        }
        return s.substring(x1 + 1, x2);
    }

    public TextBlock asTextBlock(final HtmlColor color, final double factor) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                OpenIcon.this.svgPath.drawMe(ug.apply(new UChangeColor(color)), factor);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return OpenIcon.this.getDimension(factor);
            }
        };
    }
}

