/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;

class FontFamilyChange
implements FontChange {
    private static final Pattern colorPattern = MyPattern.cmpile("(?i)\\<font[\\s:]+([^>]+)/?\\>");
    private final String family;

    FontFamilyChange(String s) {
        Matcher matcherColor = colorPattern.matcher(s);
        if (!matcherColor.find()) {
            throw new IllegalArgumentException();
        }
        this.family = StringUtils.trin(matcherColor.group(1));
    }

    @Override
    public FontConfiguration apply(FontConfiguration initial) {
        return initial.changeFamily(this.family);
    }
}

