/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLinux;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizWindows;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class GraphvizUtils {
    private static int DOT_VERSION_LIMIT = 226;
    private static String dotVersion = null;

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    @Deprecated
    public static Graphviz create(String dotString, String ... type) {
        AbstractGraphviz result = GraphvizUtils.isWindows() ? new GraphvizWindows(dotString, type) : new GraphvizLinux(dotString, type);
        return result;
    }

    public static File getDotExe() {
        return GraphvizUtils.create(null, "png").getDotExe();
    }

    public static String getenvGraphvizDot() {
        String env = System.getProperty("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    public static String getenvLogData() {
        String env = System.getProperty("PLANTUML_LOGDATA");
        if (StringUtils.isNotEmpty(env)) {
            return env;
        }
        return System.getenv("PLANTUML_LOGDATA");
    }

    public static String dotVersion() throws IOException, InterruptedException {
        if (dotVersion == null) {
            dotVersion = GraphvizUtils.getDotExe() == null ? "Error: Dot not installed" : (!GraphvizUtils.getDotExe().exists() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " does not exist" : (!GraphvizUtils.getDotExe().isFile() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " is not a file" : (!GraphvizUtils.getDotExe().canRead() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " cannot be read" : GraphvizUtils.create(null, "png").dotVersion())));
        }
        return dotVersion;
    }

    public static int retrieveVersion(String s) {
        if (s == null) {
            return -1;
        }
        Pattern p = Pattern.compile("\\s([12].\\d\\d)\\D");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return -1;
        }
        return Integer.parseInt(m.group(1).replaceAll("\\.", ""));
    }

    public static int getDotVersion() throws IOException, InterruptedException {
        return GraphvizUtils.retrieveVersion(GraphvizUtils.dotVersion());
    }

    public static List<String> getTestDotStrings(boolean withRichText) {
        ArrayList<String> result;
        block17: {
            String red = "";
            String bold = "";
            if (withRichText) {
                red = "<b><color:red>";
                bold = "<b>";
            }
            result = new ArrayList<String>();
            String ent = GraphvizUtils.getenvGraphvizDot();
            if (ent == null) {
                result.add("The environment variable GRAPHVIZ_DOT has not been set");
            } else {
                result.add("The environment variable GRAPHVIZ_DOT has been set to " + ent);
            }
            File dotExe = GraphvizUtils.getDotExe();
            result.add("Dot executable is " + dotExe);
            boolean ok = true;
            if (dotExe == null) {
                result.add(red + "Error: No dot executable found");
                ok = false;
            } else if (!dotExe.exists()) {
                result.add(red + "Error: file does not exist");
                ok = false;
            } else if (!dotExe.isFile()) {
                result.add(red + "Error: not a valid file");
                ok = false;
            } else if (!dotExe.canRead()) {
                result.add(red + "Error: cannot be read");
                ok = false;
            }
            if (ok) {
                try {
                    String version = GraphvizUtils.dotVersion();
                    result.add("Dot version: " + version);
                    int v = GraphvizUtils.getDotVersion();
                    if (v == -1) {
                        result.add("Warning : cannot determine dot version");
                        break block17;
                    }
                    if (v < DOT_VERSION_LIMIT) {
                        result.add(bold + "Warning : Your dot installation seems old");
                        result.add(bold + "Some diagrams may have issues");
                        break block17;
                    }
                    String err = GraphvizUtils.getTestCreateSimpleFile();
                    if (err == null) {
                        result.add(bold + "Installation seems OK. File generation OK");
                        break block17;
                    }
                    result.add(red + err);
                }
                catch (Exception e) {
                    result.add(red + e.toString());
                    e.printStackTrace();
                }
            } else {
                result.add("Error: only sequence diagrams will be generated");
            }
        }
        return Collections.unmodifiableList(result);
    }

    static String getTestCreateSimpleFile() throws IOException {
        ByteArrayOutputStream baos;
        Graphviz graphviz2 = GraphvizUtils.create("digraph foo { test; }", "svg");
        ProcessState state = graphviz2.createFile3(baos = new ByteArrayOutputStream());
        if (state.differs(ProcessState.TERMINATED_OK())) {
            return "Error: timeout " + state;
        }
        byte[] data = baos.toByteArray();
        if (data.length == 0) {
            return "Error: dot generates empty file. Check you dot installation.";
        }
        String s = new String(data);
        if (s.indexOf("<svg") == -1) {
            return "Error: dot generates unreadable SVG file. Check you dot installation.";
        }
        return null;
    }
}

