/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.svek.GroupPngMakerState;
import net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierState {
    private final CucaDiagram diagram;

    public CucaDiagramSimplifierState(CucaDiagram diagram, List<String> dotStrings) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        do {
            changed = false;
            Collection<IGroup> groups = this.putConcurrentStateAtEnd(diagram.getGroups(false));
            for (IGroup g : groups) {
                if (!diagram.isAutarkic(g)) continue;
                IEntityImage img = this.computeImage(g);
                g.overideImage(img, g.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                changed = true;
            }
        } while (changed);
    }

    private Collection<IGroup> putConcurrentStateAtEnd(Collection<IGroup> groups) {
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        ArrayList<IGroup> end = new ArrayList<IGroup>();
        for (IGroup g : groups) {
            if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
                end.add(g);
                continue;
            }
            result.add(g);
        }
        result.addAll(end);
        return result;
    }

    private IEntityImage computeImage(IGroup g) throws IOException, InterruptedException {
        GroupPngMakerState maker = new GroupPngMakerState(this.diagram, g);
        return maker.getImage();
    }
}

