/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.ANodeImpl;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.BoardExplorer;
import net.sourceforge.plantuml.graph.Graph5;
import net.sourceforge.plantuml.graph.Heap;
import net.sourceforge.plantuml.graph.Zoda2;

public final class CucaDiagramPngMaker3 {
    private final CucaDiagram diagram;

    public CucaDiagramPngMaker3(CucaDiagram diagram) {
        this.diagram = diagram;
    }

    public void createPng(OutputStream os) throws IOException {
        Zoda2 zoda2 = new Zoda2();
        for (Link link : this.diagram.getLinks()) {
            String s = link.getEntity1().getCode() + "->" + link.getEntity2().getCode();
            int diffHeight = link.getLength() - 1;
            zoda2.addLink(s, diffHeight, link);
        }
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            ANode n = zoda2.getNode(iEntity.getCode().getFullName());
            if (n == null) {
                n = zoda2.createAloneNode(iEntity.getCode().getFullName());
            }
            ((ANodeImpl)n).setUserData(iEntity);
        }
        List<Graph5> graphs = this.getGraphs3(zoda2.getHeaps());
        Dimension2D dimension2D = this.getTotalDimension(graphs);
        EmptyImageBuilder im = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), Color.WHITE);
        double x = 0.0;
        Graphics2D g2d = im.getGraphics2D();
        for (Graph5 g : graphs) {
            g2d.setTransform(new AffineTransform());
            g2d.translate(x, 0.0);
            g.draw(g2d);
            x += g.getDimension().getWidth();
        }
        ImageIO.write((RenderedImage)im.getBufferedImage(), "png", os);
    }

    private Dimension2D getTotalDimension(List<Graph5> graphs) {
        double width = 0.0;
        double height = 0.0;
        for (Graph5 g : graphs) {
            width += g.getDimension().getWidth();
            height = Math.max(height, g.getDimension().getHeight());
        }
        return new Dimension2DDouble(width, height);
    }

    private List<Graph5> getGraphs3(Collection<Heap> heaps) {
        ArrayList<Graph5> result = new ArrayList<Graph5>();
        for (Heap h : heaps) {
            boolean finished;
            h.computeRows();
            Board board = new Board(h.getNodes(), h.getLinks());
            BoardExplorer boardExplorer = new BoardExplorer(board);
            long start = System.currentTimeMillis();
            for (int i = 0; i < 400 && !(finished = boardExplorer.onePass()); ++i) {
                if (i % 100 != 0) continue;
                Log.info("" + i + " boardExplorer.getBestCost()=" + boardExplorer.getBestCost() + " " + boardExplorer.collectionSize());
            }
            Log.info("################# DURATION = " + (System.currentTimeMillis() - start));
            board = boardExplorer.getBestBoard();
            result.add(new Graph5(board));
        }
        return result;
    }
}

