/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Removeable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbolInterface;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class Link
implements Hideable,
Removeable {
    private final IEntity cl1;
    private final IEntity cl2;
    private LinkType type;
    private final Display label;
    private int length;
    private final String qualifier1;
    private final String qualifier2;
    private final String uid = "LNK" + UniqueSequence.getValue();
    private Display note;
    private Position notePosition;
    private Colors noteColors;
    private boolean invis = false;
    private double weight = 1.0;
    private final String labeldistance;
    private final String labelangle;
    private HtmlColor specificColor;
    private boolean constraint = true;
    private boolean inverted = false;
    private LinkArrow linkArrow = LinkArrow.NONE;
    private boolean opale;
    private boolean horizontalSolitary;
    private String sametail;
    private Url url;
    private boolean hidden = false;
    private Colors colors;

    public Link(IEntity cl1, IEntity cl2, LinkType type, Display label, int length) {
        this(cl1, cl2, type, label, length, null, null, null, null, null);
    }

    public Link(IEntity cl1, IEntity cl2, LinkType type, Display label, int length, String qualifier1, String qualifier2, String labeldistance, String labelangle) {
        this(cl1, cl2, type, label, length, qualifier1, qualifier2, labeldistance, labelangle, null);
    }

    public Link(IEntity cl1, IEntity cl2, LinkType type, Display label, int length, String qualifier1, String qualifier2, String labeldistance, String labelangle, HtmlColor specificColor) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        if (cl1 == null) {
            throw new IllegalArgumentException();
        }
        if (cl2 == null) {
            throw new IllegalArgumentException();
        }
        this.cl1 = cl1;
        this.cl2 = cl2;
        this.type = type;
        if (Display.isNull(label)) {
            this.label = Display.NULL;
        } else if (Link.doWeHaveToRemoveUrlAtStart(label)) {
            this.url = label.initUrl();
            this.label = label.removeUrl(this.url);
        } else {
            this.label = label;
        }
        this.length = length;
        this.qualifier1 = qualifier1;
        this.qualifier2 = qualifier2;
        this.labeldistance = labeldistance;
        this.labelangle = labelangle;
        this.specificColor = specificColor;
        if (qualifier1 != null) {
            ((ILeaf)cl1).setNearDecoration(true);
        }
        if (qualifier2 != null) {
            ((ILeaf)cl2).setNearDecoration(true);
        }
    }

    private static boolean doWeHaveToRemoveUrlAtStart(Display label) {
        if (label.size() == 0) {
            return false;
        }
        String s = label.get(0).toString();
        return s.matches("^\\[\\[\\S+\\]\\].+$");
    }

    public Link getInv() {
        Link result = new Link(this.cl2, this.cl1, this.getType().getInversed(), this.label, this.length, this.qualifier2, this.qualifier1, this.labeldistance, this.labelangle, this.specificColor);
        result.inverted = true;
        return result;
    }

    public void goDashed() {
        this.type = this.type.getDashed();
    }

    public void goDotted() {
        this.type = this.type.getDotted();
    }

    public void goHidden() {
        this.hidden = true;
    }

    public void goNorank() {
        this.setConstraint(false);
    }

    public void goBold() {
        this.type = this.type.getBold();
    }

    public String getLabeldistance() {
        return this.labeldistance;
    }

    public String getLabelangle() {
        return this.labelangle;
    }

    public String getUid() {
        return this.uid;
    }

    public final boolean isInvis() {
        if (this.type.isInvisible()) {
            return true;
        }
        return this.invis;
    }

    public final void setInvis(boolean invis) {
        this.invis = invis;
    }

    public boolean isBetween(IEntity cl1, IEntity cl2) {
        if (cl1.equals(this.cl1) && cl2.equals(this.cl2)) {
            return true;
        }
        return cl1.equals(this.cl2) && cl2.equals(this.cl1);
    }

    public String toString() {
        return super.toString() + " {" + this.length + "} " + this.cl1 + "-->" + this.cl2;
    }

    public IEntity getEntity1() {
        return this.cl1;
    }

    public IEntity getEntity2() {
        return this.cl2;
    }

    public LinkType getType() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        if (this.getSametail() != null) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private LinkType getTypeSpecialForPrinting() {
        if (this.opale) {
            return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
        }
        LinkType result = this.type;
        return result;
    }

    private boolean isLollipopInterfaceEye(IEntity ent) {
        return ent.getUSymbol() instanceof USymbolInterface;
    }

    public Display getLabel() {
        return this.label;
    }

    public int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public String getQualifier1() {
        return this.qualifier1;
    }

    public String getQualifier2() {
        return this.qualifier2;
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double weight) {
        this.weight = weight;
    }

    public final Display getNote() {
        return this.note;
    }

    public final Colors getNoteColors() {
        return this.noteColors;
    }

    public final Position getNotePosition() {
        return this.notePosition;
    }

    public final void addNote(Display note, Position position, Colors colors) {
        this.note = note;
        this.notePosition = position;
        this.noteColors = colors;
    }

    public boolean isAutoLinkOfAGroup() {
        if (!this.getEntity1().isGroup()) {
            return false;
        }
        if (!this.getEntity2().isGroup()) {
            return false;
        }
        return this.getEntity1() == this.getEntity2();
    }

    public boolean containsType(LeafType type) {
        return this.getEntity1().getEntityType() == type || this.getEntity2().getEntityType() == type;
    }

    public boolean contains(IEntity entity) {
        return this.getEntity1() == entity || this.getEntity2() == entity;
    }

    public IEntity getOther(IEntity entity) {
        if (this.getEntity1() == entity) {
            return this.getEntity2();
        }
        if (this.getEntity2() == entity) {
            return this.getEntity1();
        }
        throw new IllegalArgumentException();
    }

    public double getMarginDecors1(StringBounder stringBounder, UFont fontQualif, ISkinSimple spriteContainer) {
        double q = this.getQualifierMargin(stringBounder, fontQualif, this.qualifier1, spriteContainer);
        LinkDecor decor = this.getType().getDecor1();
        return (double)decor.getMargin() + q;
    }

    public double getMarginDecors2(StringBounder stringBounder, UFont fontQualif, ISkinSimple spriteContainer) {
        double q = this.getQualifierMargin(stringBounder, fontQualif, this.qualifier2, spriteContainer);
        LinkDecor decor = this.getType().getDecor2();
        return (double)decor.getMargin() + q;
    }

    private double getQualifierMargin(StringBounder stringBounder, UFont fontQualif, String qualif, ISkinSimple spriteContainer) {
        if (qualif != null) {
            TextBlock b = Display.create(qualif).create(FontConfiguration.blackBlueTrue(fontQualif), HorizontalAlignment.LEFT, spriteContainer);
            Dimension2D dim = b.calculateDimension(stringBounder);
            return Math.max(dim.getWidth(), dim.getHeight());
        }
        return 0.0;
    }

    public HtmlColor getSpecificColor() {
        return this.specificColor;
    }

    public void setSpecificColor(String s) {
        this.specificColor = HtmlColorSet.getInstance().getColorIfValid(s);
    }

    public final boolean isConstraint() {
        return this.constraint;
    }

    public final void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    public void setOpale(boolean opale) {
        this.opale = opale;
    }

    public final void setHorizontalSolitary(boolean horizontalSolitary) {
        this.horizontalSolitary = horizontalSolitary;
    }

    public final boolean isHorizontalSolitary() {
        return this.horizontalSolitary;
    }

    public final LinkArrow getLinkArrow() {
        if (this.inverted) {
            return this.linkArrow.reverse();
        }
        return this.linkArrow;
    }

    public final void setLinkArrow(LinkArrow linkArrow) {
        this.linkArrow = linkArrow;
    }

    public final boolean isInverted() {
        return this.inverted;
    }

    public boolean hasEntryPoint() {
        return !this.getEntity1().isGroup() && ((ILeaf)this.getEntity1()).getEntityPosition() != EntityPosition.NORMAL || !this.getEntity2().isGroup() && ((ILeaf)this.getEntity2()).getEntityPosition() != EntityPosition.NORMAL;
    }

    public boolean hasTwoEntryPointsSameContainer() {
        return !this.getEntity1().isGroup() && !this.getEntity2().isGroup() && ((ILeaf)this.getEntity1()).getEntityPosition() != EntityPosition.NORMAL && ((ILeaf)this.getEntity2()).getEntityPosition() != EntityPosition.NORMAL && this.getEntity1().getParentContainer() == this.getEntity2().getParentContainer();
    }

    public Url getUrl() {
        return this.url;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    @Override
    public boolean isHidden() {
        return this.hidden || this.cl1.isHidden() || this.cl2.isHidden();
    }

    public boolean sameConnections(Link other) {
        if (this.cl1 == other.cl1 && this.cl2 == other.cl2) {
            return true;
        }
        return this.cl1 == other.cl2 && this.cl2 == other.cl1;
    }

    public boolean doesTouch(Link other) {
        if (this.cl1 == other.cl1) {
            return true;
        }
        if (this.cl1 == other.cl2) {
            return true;
        }
        if (this.cl2 == other.cl1) {
            return true;
        }
        return this.cl2 == other.cl2;
    }

    public boolean isAutolink() {
        return this.cl1 == this.cl2;
    }

    @Override
    public boolean isRemoved() {
        return this.cl1.isRemoved() || this.cl2.isRemoved();
    }

    public boolean hasUrl() {
        if (!Display.isNull(this.label) && this.label.hasUrl()) {
            return true;
        }
        return this.getUrl() != null;
    }

    public String getSametail() {
        return this.sametail;
    }

    public void setSametail(String sametail) {
        this.sametail = sametail;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Colors getColors() {
        return this.colors;
    }
}

