/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontPosition;

public class CommandCreoleExposantChange
implements Command {
    private final Pattern pattern;
    private final FontPosition position;

    private CommandCreoleExposantChange(String p, FontPosition position) {
        this.pattern = MyPattern.cmpile(p);
        this.position = position;
    }

    public static Command create(FontPosition position) {
        return new CommandCreoleExposantChange("^(?i)(\\<" + position.getHtmlTag() + "\\>" + "(.*?)\\</" + position.getHtmlTag() + "\\>)", position);
    }

    @Override
    public int matchingSize(String line) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFontPosition(this.position);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(2));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

