/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import net.sourceforge.plantuml.api.INumberAnalyzed;

public class NumberAnalyzed
implements INumberAnalyzed {
    private int nb;
    private int sum;
    private int min;
    private int max;

    public NumberAnalyzed() {
    }

    private NumberAnalyzed(int nb, int sum, int min, int max) {
        this.nb = nb;
        this.sum = sum;
        this.min = min;
        this.max = max;
    }

    public synchronized INumberAnalyzed getCopyImmutable() {
        NumberAnalyzed copy = new NumberAnalyzed(this.nb, this.sum, this.min, this.max);
        return copy;
    }

    public synchronized void addValue(int v) {
        ++this.nb;
        if (this.nb == 1) {
            this.sum = v;
            this.min = v;
            this.max = v;
            return;
        }
        this.sum += v;
        if (v > this.max) {
            this.max = v;
        }
        if (v < this.min) {
            this.min = v;
        }
    }

    @Override
    public final synchronized int getNb() {
        return this.nb;
    }

    @Override
    public final synchronized int getSum() {
        return this.sum;
    }

    @Override
    public final synchronized int getMin() {
        return this.min;
    }

    @Override
    public final synchronized int getMax() {
        return this.max;
    }

    @Override
    public final synchronized int getMean() {
        if (this.nb == 0) {
            return 0;
        }
        return this.sum / this.nb;
    }
}

