/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private Display note;
    private NotePosition notePosition;
    private final BoxStyle style;
    private final Url url;

    public InstructionSimple(Display label, LinkRendering inlinkRendering, Swimlane swimlane, BoxStyle style, Url url, Colors colors) {
        super(swimlane);
        if (colors == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.style = style;
        this.label = label;
        this.inlinkRendering = inlinkRendering;
        this.colors = colors;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors);
        if (this.url != null) {
            result = factory.addUrl(result, this.url);
        }
        if (this.note != null) {
            result = factory.addNote(result, this.note, this.notePosition);
        }
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public void add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        this.note = note;
        this.notePosition = position;
        return true;
    }
}

