/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.anim.AnimationDecoder;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

public abstract class UmlDiagram
extends AbstractPSystem
implements Diagram {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private Display title = Display.NULL;
    private Display header = Display.NULL;
    private Display footer = Display.NULL;
    private Display legend = Display.NULL;
    private HorizontalAlignment legendAlignment = HorizontalAlignment.CENTER;
    private VerticalAlignment legendVerticalAlignment = VerticalAlignment.BOTTOM;
    private HorizontalAlignment headerAlignment = HorizontalAlignment.RIGHT;
    private HorizontalAlignment footerAlignment = HorizontalAlignment.CENTER;
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private Animation animation;
    private final SkinParam skinParam = new SkinParam();
    private Dimension2D lastInfo;

    public final void setTitle(Display strings) {
        this.title = strings;
    }

    @Override
    public final Display getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int minwidth) {
        this.minwidth = minwidth;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    public final Display getHeader() {
        return this.header;
    }

    public final void setHeader(Display header) {
        this.header = header;
    }

    public final Display getFooter() {
        return this.footer;
    }

    public final void setFooter(Display footer) {
        this.footer = footer;
    }

    public final HorizontalAlignment getHeaderAlignment() {
        return this.headerAlignment;
    }

    public final void setHeaderAlignment(HorizontalAlignment headerAlignment) {
        this.headerAlignment = headerAlignment;
    }

    public final HorizontalAlignment getFooterAlignment() {
        return this.footerAlignment;
    }

    public final HorizontalAlignment getAlignmentTeoz(FontParam param) {
        if (param == FontParam.FOOTER) {
            return this.getFooterAlignment();
        }
        if (param == FontParam.HEADER) {
            return this.getHeaderAlignment();
        }
        throw new IllegalArgumentException();
    }

    public final Display getFooterOrHeaderTeoz(FontParam param) {
        if (param == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (param == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    public final void setFooterAlignment(HorizontalAlignment footerAlignment) {
        this.footerAlignment = footerAlignment;
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final void setAnimation(Iterable<CharSequence> animationData) {
        try {
            AnimationDecoder animationDecoder = new AnimationDecoder(animationData);
            this.animation = Animation.create(animationDecoder.decode());
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean hideUnlinkedData) {
        this.hideUnlinkedData = hideUnlinkedData;
    }

    @Override
    public final ImageData exportDiagram(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(os, index);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(os, index, fileFormatOption);
            this.lastInfo = new Dimension2DDouble(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (UnparsableGraphvizException e) {
            e.printStackTrace();
            this.exportDiagramError(os, e.getCause(), fileFormatOption, e.getGraphvizVersion());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exportDiagramError(os, e, fileFormatOption, null);
        }
        return new ImageDataSimple();
    }

    private void exportDiagramError(OutputStream os, Throwable exception, FileFormatOption fileFormat, String graphvizVersion) throws IOException {
        UmlDiagram.exportDiagramError2(os, exception, fileFormat, this.getMetadata(), this.getFlashData(), UmlDiagram.getFailureText1(exception, graphvizVersion));
    }

    public static void exportDiagramError2(OutputStream os, Throwable exception, FileFormatOption fileFormat, String metadata, String flash, List<String> strings) throws IOException {
        UFont font = new UFont("SansSerif", 0, 12);
        strings.addAll(CommandExecutionResult.getStackTrace(exception));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, metadata, null, 0.0, 0.0, null, false);
        FlashCodeUtils utils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage im = utils.exportFlashcode(flash);
        if (im != null) {
            GraphvizCrash.addDecodeHint(strings);
        }
        final GraphicStrings graphicStrings = new GraphicStrings(strings, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        if (im == null) {
            imageBuilder.addUDrawable(graphicStrings);
        } else {
            imageBuilder.addUDrawable(new UDrawable(){

                @Override
                public void drawU(UGraphic ug) {
                    graphicStrings.drawU(ug);
                    double height = graphicStrings.calculateDimension(ug.getStringBounder()).getHeight();
                    ug = ug.apply(new UTranslate(0.0, height));
                    ug.draw(new UImage(im));
                }
            });
        }
        imageBuilder.writeImageTOBEMOVED(fileFormat, os);
    }

    private String getFlashData() {
        StringBuilder result = new StringBuilder();
        UmlSource source = this.getSource();
        result.append(source.getPlainString());
        return result.toString();
    }

    private static List<String> getFailureText1(Throwable exception, String graphvizVersion) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = QuoteUtils.getSomeQuote();
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (exception instanceof EmptySvgException) {
            strings.add("Because dot/GraphViz returns an empty string.");
        }
        if (graphvizVersion != null) {
            strings.add(" ");
            strings.add("GraphViz version used : " + graphvizVersion);
        }
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("This may be caused by :");
        strings.add(" - a bug in PlantUML");
        strings.add(" - a problem in GraphViz");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        strings.add("You can try to turn arround this issue by simplifing your diagram.");
        strings.add(" ");
        return strings;
    }

    public static List<String> getFailureText2(Throwable exception) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = QuoteUtils.getSomeQuote();
        strings.add("<i>" + quote);
        strings.add(" ");
        strings.add("PlantUML (" + Version.versionString() + ") has crashed.");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        strings.add("You can try to turn arround this issue by simplifing your diagram.");
        strings.add(" ");
        return strings;
    }

    private void exportDiagramInternalMjpeg(OutputStream os) throws IOException {
        File f = new File("c:/test.avi");
        int nb = 150;
        double framerate = 30.0;
        MJPEGGenerator m = new MJPEGGenerator(f, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform at = new AffineTransform();
            double coef = (double)(149 - i) * 1.0 / 150.0;
            at.setToShear(coef, coef);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.close();
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            m.addImage(im);
        }
        m.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream os, int index) throws IOException {
        File svg = FileUtils.createTempFile("pdf", ".svf");
        File pdfFile = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(svg));
        ImageData result = this.exportDiagram(fos, index, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)fos).close();
        PdfConverter.convert(svg, pdfFile);
        FileUtils.copyToStream(pdfFile, os);
        return result;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(File suggestedFile, ImageData cmapdata) throws FileNotFoundException {
        String name = UmlDiagram.changeName(suggestedFile.getAbsolutePath());
        File cmapFile = new File(name);
        PrintWriter pw = null;
        try {
            if (!PSystemUtils.canFileBeWritten(cmapFile)) {
                return;
            }
            pw = new PrintWriter(cmapFile);
            pw.print(cmapdata.getCMapData(cmapFile.getName().substring(0, cmapFile.getName().length() - 6)));
            pw.close();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static String changeName(String name) {
        return name.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double actualWidth = this.lastInfo.getWidth();
        if (actualWidth == 0.0) {
            return null;
        }
        String value = this.getSkinParam().getValue("widthwarning");
        if (value == null) {
            return null;
        }
        if (!value.matches("\\d+")) {
            return null;
        }
        int widthwarning = Integer.parseInt(value);
        if (actualWidth > (double)widthwarning) {
            return "The image is " + (int)actualWidth + " pixel width. (Warning limit is " + widthwarning + ")";
        }
        return null;
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    public final Display getLegend() {
        return this.legend;
    }

    public final HorizontalAlignment getLegendAlignment() {
        return this.legendAlignment;
    }

    public final VerticalAlignment getLegendVerticalAlignment() {
        return this.legendVerticalAlignment;
    }

    public final void setLegend(Display legend, HorizontalAlignment horizontalAlignment, VerticalAlignment valignment) {
        this.legend = legend;
        this.legendAlignment = horizontalAlignment;
        this.legendVerticalAlignment = valignment;
    }
}

