/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UText;

public class DriverTextG2d
implements UDriver<Graphics2D> {
    private final EnsureVisible visible;

    public DriverTextG2d(EnsureVisible visible) {
        this.visible = visible;
    }

    private static void printFont() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        int j = fontNames.length;
        for (int i = 0; i < j; ++i) {
            Log.info("Available fonts: " + fontNames[i]);
        }
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        Dimension2D dim;
        int ypos;
        Object extended;
        UText shape = (UText)ushape;
        FontConfiguration fontConfiguration = shape.getFontConfiguration();
        UFont font = fontConfiguration.getFont().scaled(param.getScale());
        Dimension2D dimBack = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(g2d), font, shape.getText());
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR) && (extended = mapper.getMappedColor(fontConfiguration.getExtendedColor())) != null) {
            g2d.setColor((Color)extended);
            g2d.setBackground((Color)extended);
            g2d.fill(new Rectangle2D.Double(x, y - dimBack.getHeight() + 1.5, dimBack.getWidth(), dimBack.getHeight()));
        }
        this.visible.ensureVisible(x, y - dimBack.getHeight() + 1.5);
        this.visible.ensureVisible(x + dimBack.getWidth(), y + 1.5);
        g2d.setFont(font.getFont());
        g2d.setColor(mapper.getMappedColor(fontConfiguration.getColor()));
        g2d.drawString(shape.getText(), (float)x, (float)y);
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            extended = fontConfiguration.getExtendedColor();
            if (extended != null) {
                g2d.setColor(mapper.getMappedColor((HtmlColor)extended));
            }
            Dimension2D dim2 = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(g2d), font, shape.getText());
            ypos = (int)(y + 2.5);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine((int)x, ypos, (int)(x + dim2.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
        if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
            dim = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(g2d), font, shape.getText());
            int ypos2 = (int)(y + 2.5) - 1;
            HtmlColor extended2 = fontConfiguration.getExtendedColor();
            if (extended2 != null) {
                g2d.setColor(mapper.getMappedColor(extended2));
            }
            int i = (int)x;
            while ((double)i < x + dim.getWidth() - 5.0) {
                g2d.drawLine(i, ypos2 - 0, i + 3, ypos2 + 1);
                g2d.drawLine(i + 3, ypos2 + 1, i + 6, ypos2 - 0);
                i += 6;
            }
        }
        if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            dim = DriverTextG2d.calculateDimension(StringBounderUtils.asStringBounder(g2d), font, shape.getText());
            FontMetrics fm = g2d.getFontMetrics(font.getFont());
            ypos = (int)(y - (double)fm.getDescent() - 0.5);
            HtmlColor extended3 = fontConfiguration.getExtendedColor();
            if (extended3 != null) {
                g2d.setColor(mapper.getMappedColor(extended3));
            }
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.drawLine((int)x, ypos, (int)(x + dim.getWidth()), ypos);
            g2d.setStroke(new BasicStroke());
        }
    }

    public static Dimension2D calculateDimension(StringBounder stringBounder, UFont font, String text) {
        Dimension2D rect = stringBounder.calculateDimension(font, text);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        return new Dimension2DDouble(rect.getWidth(), h);
    }
}

