/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class AbstractComponent
implements Component {
    protected final void stroke(Graphics2D g2d, float dash, float thickness) {
        float[] style = new float[]{dash, dash};
        g2d.setStroke(new BasicStroke(thickness, 0, 0, 10.0f, style, 0.0f));
    }

    protected final UGraphic stroke(UGraphic ug, double dashVisible, double dashSpace, double thickness) {
        return ug.apply(new UStroke(dashVisible, dashSpace, thickness));
    }

    protected final void stroke(Graphics2D g2d, float dash) {
        this.stroke(g2d, dash, 1.0f);
    }

    protected final UGraphic stroke(UGraphic ug, double dashVisible, double dashSpace) {
        return this.stroke(ug, dashVisible, dashSpace, 1.0);
    }

    protected abstract void drawInternalU(UGraphic var1, Area var2);

    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
    }

    @Override
    public final void drawU(UGraphic ug, Area area, Context2D context) {
        ug = ug.apply(new UTranslate(this.getPaddingX(), this.getPaddingY()));
        if (context.isBackground()) {
            this.drawBackgroundInternalU(ug, area);
        } else {
            this.drawInternalU(ug, area);
        }
    }

    public double getPaddingX() {
        return 0.0;
    }

    public double getPaddingY() {
        return 0.0;
    }

    @Override
    public abstract double getPreferredWidth(StringBounder var1);

    @Override
    public abstract double getPreferredHeight(StringBounder var1);

    @Override
    public final Dimension2D getPreferredDimension(StringBounder stringBounder) {
        double w = this.getPreferredWidth(stringBounder);
        double h = this.getPreferredHeight(stringBounder);
        return new Dimension2DDouble(w, h);
    }
}

