/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Project2;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.RowSimple;
import net.sourceforge.plantuml.project2.RowUtils;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram2 {
    private final Project2 project;
    private final double dayWith = 20.0;
    private final UFont font = new UFont("Serif", 0, 9);
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public GanttDiagram2(Project2 project) {
        this.project = project;
    }

    public void draw(UGraphic ug, double x, double y) {
        TextBlock timeHeader = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock headers = row.header();
        double deltaX = headers.calculateDimension(ug.getStringBounder()).getWidth();
        double deltaY = timeHeader.calculateDimension(ug.getStringBounder()).getHeight();
        headers.drawU(ug.apply(new UTranslate(x, y + deltaY)));
        TextBlock tbRow = row.asTextBloc(this.project.getTimeConverter(20.0));
        tbRow.drawU(ug.apply(new UTranslate(x + deltaX, y + deltaY)));
        timeHeader.drawU(ug.apply(new UTranslate(x + deltaX, y)));
    }

    private Row getMainRow() {
        List<Task> tasks = this.project.getTasks();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Task t : tasks) {
            String text = t.getCode();
            TextBlock label = Display.create(text).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            rows.add(new RowSimple((Day)t.getStart(), (Day)t.getEnd(), HtmlColorUtils.BLACK, TextBlockUtils.withMargin(label, 3.0, 3.0)));
        }
        Row row = RowUtils.merge(rows);
        return row;
    }

    public double getWidth(StringBounder stringBounder) {
        TextBlock timeHeader = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock headers = row.header();
        return headers.calculateDimension(stringBounder).getWidth() + timeHeader.calculateDimension(stringBounder).getWidth() + 1.0;
    }

    public double getHeight(StringBounder stringBounder) {
        TextBlock timeHeader = this.project.getTimeHeader(20.0);
        Row row = this.getMainRow();
        TextBlock headers = row.header();
        return headers.calculateDimension(stringBounder).getHeight() + timeHeader.calculateDimension(stringBounder).getHeight();
    }
}

